/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.rtc.RtcLoginInterceptor;
import com.teamscale.index.issues.rtc.client.IRtcWorkItemApi;
import com.teamscale.index.issues.rtc.client.RtcWorkItemParser;
import com.teamscale.index.issues.rtc.client.model.RtcPaginatedWorkItemList;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jetbrains.annotations.VisibleForTesting;
import retrofit2.Call;

public class RtcWorkItemClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(30L);
    private static final int CHUNK_SIZE = 1000;
    private static final String FIELD_SELECTOR = "id|summary|@href|itemId|description|creationDate|modified|state/(name|group)|owner/name|creator/name|priority/name|severity/name|type/name|tags|teamArea/name|parent/id";
    private final String username;
    private final String password;
    private final IRtcWorkItemApi rtc;

    public RtcWorkItemClient(String baseUrl, String username, String password) {
        this.rtc = (IRtcWorkItemApi)Retrofit.builder((String)baseUrl).withReadTimeout(REQUEST_TIMEOUT.toSeconds()).withInteractionLogger(LOGGER).withNoAuthentication().withPreservedCookies().withInterceptors(new Interceptor[]{new RtcLoginInterceptor((RunnableWithException<ServiceCallException>)((RunnableWithException)this::sendLoginRequests))}).withDisabledRedirectsForPost().create(IRtcWorkItemApi.class);
        this.username = username;
        this.password = password;
    }

    public List<RtcWorkItem> fetchWorkItemHistory(long id, PairList<String, Boolean> customFields, List<String> workItemLinks) throws ServiceCallException {
        List<RtcWorkItem> list;
        block8: {
            String fieldSelector = this.getWorkItemHistoryFieldSelector(id, customFields, workItemLinks);
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(this.rtc.getWorkItemHistory(fieldSelector)).orElseThrow(() -> new ServiceCallException("Response was empty."));
            try {
                String content = responseBody.string();
                list = this.parseWorkItemHistory(content, customFields);
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return list;
    }

    private List<RtcWorkItem> parseWorkItemHistory(String content, PairList<String, Boolean> customFields) throws ServiceCallException {
        try {
            return RtcWorkItemParser.parseWorkItemHistory(content, customFields);
        }
        catch (IOException | JsonSerializationException e) {
            throw new ServiceCallException("Could not parse work item history XML. Unparsable XML:\n" + content, e);
        }
    }

    public List<RtcWorkItem> fetchModifiedWorkItems(List<String> projectNames, long minimumModificationTimestamp, PairList<String, Boolean> customFields, Set<String> workItemTypes, String additionalFieldFilter, List<String> workItemLinks) throws ServiceCallException {
        String fieldSelector = this.getWorkItemListFieldSelector(projectNames, minimumModificationTimestamp, customFields, additionalFieldFilter, workItemLinks);
        ArrayList<RtcWorkItem> workItems = new ArrayList<RtcWorkItem>();
        Optional<String> nextPageUri = this.fetchWorkItems(workItems, this.rtc.getModifiedWorkItems(fieldSelector, 1000), customFields, workItemTypes);
        while (nextPageUri.isPresent()) {
            nextPageUri = this.fetchWorkItems(workItems, this.rtc.getWorkItemsFromNextPage(nextPageUri.get()), customFields, workItemTypes);
        }
        return workItems;
    }

    private Optional<String> fetchWorkItems(List<RtcWorkItem> workItems, Call<ResponseBody> request, PairList<String, Boolean> customFields, Set<String> workItemTypes) throws ServiceCallException {
        Optional<String> optional;
        block8: {
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(request).orElseThrow(() -> new ServiceCallException("Response was empty."));
            try {
                String content = responseBody.string();
                optional = this.parseWorkItemList(content, workItems, customFields, workItemTypes);
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return optional;
    }

    private Optional<String> parseWorkItemList(String content, List<RtcWorkItem> workItems, PairList<String, Boolean> customFields, Set<String> workItemTypes) throws ServiceCallException {
        try {
            RtcPaginatedWorkItemList list = RtcWorkItemParser.parseWorkItemList(content, customFields);
            if (list.workItem == null || list.workItem.isEmpty()) {
                return Optional.empty();
            }
            workItems.addAll(RtcWorkItemClient.filterWorkItemTypes(list.workItem, workItemTypes));
            return Optional.of(list.href);
        }
        catch (IOException | JsonSerializationException e) {
            throw new ServiceCallException("Could not parse work item list XML. Unparsable XML:\n" + content, e);
        }
    }

    private static List<RtcWorkItem> filterWorkItemTypes(List<RtcWorkItem> workItems, Set<String> types) {
        if (types == null || types.isEmpty()) {
            return workItems;
        }
        return workItems.stream().filter(workItem -> types.contains(workItem.getType())).collect(Collectors.toList());
    }

    public void forceLogin() throws ServiceCallException {
        this.sendLoginRequests();
    }

    private void sendLoginRequests() throws ServiceCallException {
        block4: {
            try {
                this.rtc.preLogin();
            }
            catch (ServiceCallException e) {
                LOGGER.warn("Prelogin request failed. Continuing with login request anyways.", (Throwable)e);
            }
            try {
                this.rtc.login(this.username, this.password);
            }
            catch (ServiceCallException e) {
                if (e.getStatusCode() == 302) break block4;
                throw e;
            }
        }
    }

    private String getWorkItemHistoryFieldSelector(long id, PairList<String, Boolean> customFields, List<String> workItemLinks) {
        return "workitem/workItem[id=" + id + "]/itemHistory/" + RtcWorkItemClient.createFieldSelectorClause(customFields, workItemLinks);
    }

    @VisibleForTesting
    String getWorkItemListFieldSelector(List<String> projectNames, long minimumModificationTimestamp, PairList<String, Boolean> customFields, String additionalFieldFilter, List<String> workItemLinks) {
        String projectFilter = "";
        if (!projectNames.isEmpty()) {
            projectFilter = projectNames.stream().collect(Collectors.joining("' or projectArea/name='", " and (projectArea/name='", "')"));
        }
        if (!((String)additionalFieldFilter).isEmpty()) {
            additionalFieldFilter = " and (" + (String)additionalFieldFilter + ")";
        }
        ZonedDateTime dateTime = Instant.ofEpochMilli(minimumModificationTimestamp).atZone(ZoneOffset.UTC);
        String formattedTimestamp = RtcWorkItem.TIMESTAMP_FORMATTER.format(dateTime);
        return "workitem/workItem[modified>" + formattedTimestamp + projectFilter + (String)additionalFieldFilter + "]/" + RtcWorkItemClient.createFieldSelectorClause(customFields, workItemLinks);
    }

    private static String createFieldSelectorClause(PairList<String, Boolean> customFields, List<String> workItemLinks) {
        String customFieldSelectors = RtcWorkItemClient.createCustomFieldSelectors(customFields);
        String workItemLinksFieldFilter = RtcWorkItemClient.createLinkSelectors(workItemLinks);
        return "(id|summary|@href|itemId|description|creationDate|modified|state/(name|group)|owner/name|creator/name|priority/name|severity/name|type/name|tags|teamArea/name|parent/id" + customFieldSelectors + workItemLinksFieldFilter + ")";
    }

    private static String createCustomFieldSelectors(PairList<String, Boolean> customFields) {
        Map<Boolean, List<Pair>> customFieldsUserDefined = customFields.stream().collect(Collectors.partitioningBy(ImmutablePair::getSecond));
        List<String> standardCustomFields = customFieldsUserDefined.get(false).stream().map(ImmutablePair::getFirst).toList();
        List<String> userDefinedCustomFields = customFieldsUserDefined.get(true).stream().map(ImmutablePair::getFirst).toList();
        String standardCustomFieldFilter = RtcWorkItemClient.createFieldSelectorsForStandardCustomFields(standardCustomFields);
        String userDefinedCustomFieldFilter = RtcWorkItemClient.createFieldSelectorsForUserDefinedCustomFields(userDefinedCustomFields);
        return standardCustomFieldFilter + userDefinedCustomFieldFilter;
    }

    private static String createFieldSelectorsForStandardCustomFields(List<String> customFields) {
        if (customFields.isEmpty()) {
            return "";
        }
        return customFields.stream().collect(Collectors.joining("/*|", "|", "/*"));
    }

    private static String createFieldSelectorsForUserDefinedCustomFields(List<String> customFields) {
        if (customFields.isEmpty()) {
            return "";
        }
        return customFields.stream().collect(Collectors.joining("' or displayName='", "|allExtensions[displayName='", "']/(displayName|displayValue)"));
    }

    private static String createLinkSelectors(List<String> links) {
        if (links.isEmpty()) {
            return "";
        }
        return links.stream().collect(Collectors.joining("' or name='", "|auditableLinks[name='", "']/(name|sourceRef/referencedItem/itemId|targetRef/(uri|referencedItem/itemId|referenceType/literal))"));
    }
}

