/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.markup.MarkupUtils;

public class TestGapReviewComment
implements IReviewComment {
    private final AssessedTgaData.AssessedMethodData method;
    private final TeamscaleCommitLinkProvider linkProvider;
    private final @Nullable TokenElementLineInfo methodLineInfo;
    private final MergeRequestIdentifier mergeRequestIdentifier;
    public static final String TEST_GAP_COMMENT_START = "[Test Gap] ";
    private static final String TEST_GAP_COMMENT_END = "has not been tested.";
    private static final String TEST_GAP_MARKDOWN_COMMENT_START = "**[Test Gap]** ";

    public TestGapReviewComment(AssessedTgaData.AssessedMethodData method, TeamscaleCommitLinkProvider linkProvider, @Nullable TokenElementLineInfo methodLineInfo, MergeRequestIdentifier mergeRequestIdentifier) {
        this.method = method;
        this.linkProvider = linkProvider;
        this.methodLineInfo = methodLineInfo;
        this.mergeRequestIdentifier = mergeRequestIdentifier;
    }

    @Override
    public ETrafficLightColor getAssessment() {
        return ETrafficLightColor.YELLOW;
    }

    @Override
    public ElementLocation getLocation() {
        return new TextRegionLocation(this.method.getLocation().getUniformPath().toStringAsMigrationFrontier(), this.getStartOffset(), this.getEndOffset(), this.getStartLine(), this.getEndLine());
    }

    @Override
    public String getMarkdownText() {
        return TEST_GAP_MARKDOWN_COMMENT_START + this.getTestGapMessage() + " [(view in Teamscale)](" + this.getTeamscaleDetailsUrl() + ")";
    }

    @Override
    public String getText() {
        return this.getTextWithoutLinks() + "\n" + this.getTeamscaleDetailsUrl();
    }

    @Override
    public String getTextWithoutLinks() {
        return TEST_GAP_COMMENT_START + MarkupUtils.unescapeMarkdownRelevantSymbols((String)this.getTestGapMessage());
    }

    @Override
    public String getTeamscaleDetailsUrl() {
        return this.linkProvider.createMergeRequestTestGapDetailsLink(this.getLocation().getUniformPath(), this.getStartOffset(), this.getEndOffset(), this.mergeRequestIdentifier);
    }

    @Override
    public int getStartLine() {
        return this.getLineForOffset(this.getStartOffset());
    }

    private int getEndLine() {
        return this.getLineForOffset(this.getEndOffset());
    }

    private int getLineForOffset(int offset) {
        if (this.methodLineInfo == null) {
            return 1;
        }
        return this.methodLineInfo.getRawLineOffsetConverter().getLine(offset);
    }

    private int getStartOffset() {
        return this.method.getLocation().getRegion().getStart();
    }

    private int getEndOffset() {
        return this.method.getLocation().getRegion().getEnd();
    }

    @Override
    public String getCategory() {
        return "Test Gaps";
    }

    @Override
    public String getGroup() {
        return "";
    }

    @Override
    public List<ElementLocation> getSecondaryLocations() {
        return Collections.emptyList();
    }

    private String getTestGapMessage() {
        String text = "Method ";
        if (this.method.getTestGapState() == ETestGapState.UNTESTED_CHANGE) {
            text = "Changed method ";
        } else if (this.method.getTestGapState() == ETestGapState.UNTESTED_ADDITION) {
            text = "Added method ";
        }
        return text + "`" + this.method.getMethodName() + "` has not been tested.";
    }

    public ETestGapState getTestGapState() {
        return this.method.getTestGapState();
    }
}

