/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.context;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class MetricDataRetriever {
    private final IMetricRetrievalStrategy indexMetricRetrievalStrategy;

    MetricDataRetriever(IMetricRetrievalStrategy indexMetricRetrievalStrategy) {
        this.indexMetricRetrievalStrategy = indexMetricRetrievalStrategy;
    }

    public Optional<MetricDirectorySchemaEntry> getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        return Optional.ofNullable(this.indexMetricRetrievalStrategy.getMetricDirectorySchemaEntry(metricName));
    }

    public Optional<MetricDirectoryEntry> getDirectoryEntry(String uniformPath, @Nullable HistoryAccessOption historyAccessOption) throws StorageException {
        return Optional.ofNullable(this.indexMetricRetrievalStrategy.getMetricDirectoryEntry(UniformPathCompatibilityUtil.convert((String)uniformPath), historyAccessOption));
    }

    public boolean hasDirectoryEntry(String uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.indexMetricRetrievalStrategy.hasMetricDirectoryEntry(UniformPathCompatibilityUtil.convert((String)uniformPath), historyAccessOption);
    }

    public Optional<Object> getMetricValue(String metricName, String uniformPathWithSubPath, HistoryAccessOption historyAccessOption) throws StorageException {
        if (!UniformPath.isValidPath((String)uniformPathWithSubPath)) {
            return Optional.empty();
        }
        Optional<MetricDirectoryEntry> directoryEntry = this.getDirectoryEntry(uniformPathWithSubPath, historyAccessOption);
        if (directoryEntry.isEmpty()) {
            return Optional.empty();
        }
        MetricDirectorySchema metricSchema = this.indexMetricRetrievalStrategy.getMetricDirectorySchema();
        int metricPositionIndex = metricSchema.getValuePosition(metricName);
        if (metricPositionIndex == -1) {
            throw new StorageException(metricName + " does not exist in the schema.");
        }
        return Optional.ofNullable(directoryEntry.get().getValueWithoutNullAssert(metricPositionIndex));
    }

    public IMetricRetrievalStrategy getMetricRetrievalStrategy() {
        return this.indexMetricRetrievalStrategy;
    }
}

