/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion29AzureDevOpsMoreWorkItemLinksMigration {
    private static final String OLD_CONFIGURATION_OPTION = "Retrieve parent links";
    private static final String NEW_CONFIGURATION_OPTION = "Included work item link roles";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        for (ConnectorConfiguration config : holder.connectors) {
            if (!ERequirementsManagementTool.AZURE_DEVOPS.getReadableName().equals(config.getType())) continue;
            ProjectVersion29AzureDevOpsMoreWorkItemLinksMigration.migrateAzureDevOpsConnectorConfiguration(config);
        }
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static void migrateAzureDevOpsConnectorConfiguration(ConnectorConfiguration config) {
        String oldValue = config.getOptionValue(OLD_CONFIGURATION_OPTION);
        config.removeOption(OLD_CONFIGURATION_OPTION);
        if (Boolean.parseBoolean(oldValue)) {
            config.setOptionValue(NEW_CONFIGURATION_OPTION, "Parent");
        }
    }
}

