/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.findings;

import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.user.User;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.UserNotifierBase;
import com.teamscale.index.notifications.findings.EFindingsNotificationTrigger;
import com.teamscale.index.notifications.findings.FindingsNotificationMailHelper;
import com.teamscale.index.notifications.findings.FindingsNotificationRule;
import com.teamscale.index.notifications.findings.FindingsNotificationRuleIndex;
import com.teamscale.index.notifications.findings.FindingsNotificationRules;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.user.UserAliasLookup;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class FindingsNotifier
extends UserNotifierBase<FindingsNotificationRules> {
    private static final Logger LOGGER = LogManager.getLogger();
    private FindingsNotificationRuleIndex findingsNotificationRuleIndex;
    private FindingsNotificationMailHelper findingsNotificationMailHelper;
    private String mailContent;

    public FindingsNotifier(NotificationContext notificationContext, UserAliasLookup userAliasLookup) {
        super(notificationContext, userAliasLookup);
    }

    @Override
    protected void initialize() throws StorageException {
        this.findingsNotificationRuleIndex = (FindingsNotificationRuleIndex)this.notificationContext.getGlobalStorageSystem().openGlobalIndex(FindingsNotificationRuleIndex.class);
        this.findingsNotificationMailHelper = new FindingsNotificationMailHelper(this.notificationContext);
        String baseUrl = BaseUrlOption.getBaseUrl((GlobalStorageSystem)this.notificationContext.getGlobalStorageSystem());
        this.mailContent = this.findingsNotificationMailHelper.buildMailContent(baseUrl);
    }

    @Override
    protected void processRules(User user, FindingsNotificationRules notificationRules) throws StorageException {
        EnumSet<EFindingsNotificationTrigger> activatedTriggers = this.findingsNotificationMailHelper.getActivatedTriggers();
        FindingChurnList findingChurnList = this.findingsNotificationMailHelper.getFindingChurnList();
        String commitUserName = this.notificationContext.getCommitUserName();
        Optional<FindingsNotificationRule> matchedRule = notificationRules.getRules().stream().filter(rule -> rule.matches(this.notificationContext, commitUserName, activatedTriggers, findingChurnList)).findFirst();
        if (matchedRule.isPresent()) {
            String ruleName = matchedRule.get().getRuleName();
            String revision = this.notificationContext.getRepositoryLogEntry().getRevision();
            String subject = this.findingsNotificationMailHelper.buildSubject(this.notificationContext.getPrimaryPublicId(), ruleName, revision);
            LOGGER.debug("Notifying user {} with subject {} about rule {}", (Object)user, (Object)subject, (Object)ruleName);
            this.sendEmail(user, subject, this.mailContent);
        } else {
            LOGGER.info("No matching rules in FindingNotifier");
        }
    }

    @Override
    protected PairList<String, FindingsNotificationRules> getAllNotificationEntries() throws StorageException {
        return this.findingsNotificationRuleIndex.getAllNotificationRules();
    }
}

