/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IStorageKeyTranslatingIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ScatteredCollectionIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="parsed-report-content", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={ExternalAnalysisImportInfo.class})
public class ParsedReportIndex
implements IProjectIndex,
IStorageKeyTranslatingIndex {
    public static final String INDEX_NAME = "parsed-report-content";
    private final SimpleCrudIndex<String, String> reportMetadataIndex;
    private final ScatteredCollectionIndex<ExternalAnalysisImportInfo<?>> reportContentIndex;
    private final SimpleCrudIndex<String, HashSet<String>> reportPerPartitionIndex;

    public ParsedReportIndex(IStore store) {
        this.reportMetadataIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "m"), ISerializer.forString(), ISerializer.forString());
        this.reportContentIndex = ScatteredCollectionIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "c"), (int)500);
        this.reportPerPartitionIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "p"), ISerializer.forString(), ISerializer.forSerializable());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<@Nullable ParsedReport> getReports(List<String> reportPaths) throws StorageException {
        ArrayList<ParsedReport> result = new ArrayList<ParsedReport>(reportPaths.size());
        @Nullable List connectorIds = this.reportMetadataIndex.get(reportPaths);
        for (int i = 0; i < reportPaths.size(); ++i) {
            String connectorId = (String)connectorIds.get(i);
            if (connectorId == null) {
                result.add(null);
                continue;
            }
            String reportPath = reportPaths.get(i);
            List importInfos = (List)this.reportContentIndex.get(StringUtils.stringToBytes((String)reportPath)).orElseThrow(() -> new IllegalStateException("Found report metadata, but no content for report path: " + reportPath));
            result.add(new ParsedReport(new ExternalAnalysisImportInfos(importInfos), connectorId));
        }
        return result;
    }

    public void setReports(PairList<String, ParsedReport> parsedReports) throws StorageException {
        for (Pair reportPair : parsedReports) {
            String reportPath = (String)reportPair.getFirst();
            ParsedReport report = (ParsedReport)reportPair.getSecond();
            this.reportMetadataIndex.put((Object)reportPath, (Object)report.connectorId());
            this.reportContentIndex.put(StringUtils.stringToBytes((String)reportPath), report.importInfos().getInfos());
        }
        this.addReportsToPartitionReportMapping(parsedReports);
    }

    private void addReportsToPartitionReportMapping(PairList<String, ParsedReport> parsedReports) throws StorageException {
        SetMap<String, String> partitionToReportPathMapping = ParsedReportIndex.collectPartitionToReportPathMapping(parsedReports);
        for (Map.Entry entry : partitionToReportPathMapping) {
            String partition = (String)entry.getKey();
            this.reportPerPartitionIndex.merge((Object)partition, new HashSet((Collection)entry.getValue()), (oldEntry, newEntry) -> {
                oldEntry.addAll(newEntry);
                return oldEntry;
            });
        }
    }

    private static @NonNull SetMap<String, String> collectPartitionToReportPathMapping(PairList<String, @Nullable ParsedReport> parsedReports) {
        SetMap partitions = new SetMap();
        for (Pair pair : parsedReports) {
            if (pair.getSecond() == null) continue;
            ((ParsedReport)pair.getSecond()).importInfos().getInfos().forEach(info -> partitions.add((Object)info.getPartition(), (Object)((String)pair.getFirst())));
        }
        return partitions;
    }

    public void removeReports(List<String> reportPathsToRemove) throws StorageException {
        if (reportPathsToRemove.isEmpty()) {
            return;
        }
        this.removeReportsFromPartitionReportMapping(reportPathsToRemove);
        this.reportMetadataIndex.remove(reportPathsToRemove);
        for (String reportPath : reportPathsToRemove) {
            this.reportContentIndex.remove(StringUtils.stringToBytes((String)reportPath));
        }
    }

    private void removeReportsFromPartitionReportMapping(List<String> reportPathsToRemove) throws StorageException {
        for (Pair entry : this.reportPerPartitionIndex.getEntries()) {
            HashSet reports = (HashSet)entry.getSecond();
            boolean madeChange = false;
            for (String reportPath : reportPathsToRemove) {
                madeChange |= reports.remove(reportPath);
            }
            if (!madeChange) continue;
            this.reportPerPartitionIndex.put((Object)((String)entry.getFirst()), (Object)reports);
        }
    }

    public void removeReport(String reportPath) throws StorageException {
        this.removeReports(List.of(reportPath));
    }

    public void setReport(String reportPath, ParsedReport parsedReport) throws StorageException {
        this.setReports((PairList<String, ParsedReport>)PairList.from((Object)reportPath, (Object)parsedReport));
    }

    public Optional<Set<String>> getAllReportsForPartition(String partition) throws StorageException {
        return this.reportPerPartitionIndex.get((Object)partition).map(Function.identity());
    }

    public Set<StorageKey> resolveToPublicKeys(Collection<StorageKey> keys) {
        HashSet<StorageKey> result = new HashSet<StorageKey>();
        for (StorageKey key : keys) {
            DelegatingPartitionStore reportContentStore;
            DelegatingPartitionStore reportMetadataStore;
            byte[] keyBytes = key.getKey();
            IStore iStore = this.reportMetadataIndex.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (reportMetadataStore = (DelegatingPartitionStore)iStore).isFromThisPartition(keyBytes)) {
                result.add(new StorageKey(reportMetadataStore.getOriginalKey(keyBytes)));
                continue;
            }
            iStore = this.reportContentIndex.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (reportContentStore = (DelegatingPartitionStore)iStore).isFromThisPartition(keyBytes)) {
                result.addAll(this.reportContentIndex.resolveToPublicKeys(List.of(new StorageKey(reportContentStore.getOriginalKey(keyBytes)))));
                continue;
            }
            if (((DelegatingPartitionStore)this.reportPerPartitionIndex.getWrappedStore(DelegatingPartitionStore.class)).isFromThisPartition(keyBytes)) continue;
            throw new IllegalArgumentException("The key '%s' is not associated with this index.".formatted(key));
        }
        return result;
    }

    public KeyDelta resolveDelta(KeyDelta delta) {
        return KeyDelta.combineDeltas(List.of(new KeyDelta(this.resolveToPublicKeys((Collection<StorageKey>)delta.getAddedOrChangedKeys()), this.resolveToPublicKeys((Collection<StorageKey>)delta.getDeletedKeys()))));
    }

    public record ParsedReport(ExternalAnalysisImportInfos importInfos, String connectorId) {
    }
}

