/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultLineCoverageProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultLineCoverage> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private LineCoverageIndex lineCoverageIndex;
    private final Map<String, Map<String, LineCoverageInfo>> newLineCoverageInfos = new HashMap<String, Map<String, LineCoverageInfo>>();

    ExternalAnalysisResultLineCoverageProcessor() {
        this.aggregateDataOfSuccessiveUploads = true;
    }

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultLineCoverage> getResultClass() {
        return ExternalAnalysisResultLineCoverage.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultLineCoverage analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        LineCoverageInfo coverageInfo = analysisResult.getData();
        coverageInfo.setBranchName(resultsForCommit.getBranchName());
        if (LineCoverageInfo.isUndefinedTimestamp((long)coverageInfo.getCodeCommitTimestamp())) {
            coverageInfo.setCodeCommitTimestamp(resultsForCommit.getTimestamp());
        }
        if (LineCoverageInfo.isUndefinedTimestamp((long)coverageInfo.getUploadCommitTimestamp())) {
            coverageInfo.setUploadCommitTimestamp(resultsCommit.getTimestamp());
        } else if (coverageInfo.getUploadCommitTimestamp() != resultsCommit.getTimestamp()) {
            return true;
        }
        this.newLineCoverageInfos.computeIfAbsent(partition, p -> new HashMap()).merge(uniformPath.toString(), coverageInfo, ExternalAnalysisResultLineCoverageProcessor::mergeCoverage);
        return true;
    }

    private static LineCoverageInfo mergeCoverage(LineCoverageInfo lineCoverageInfo1, LineCoverageInfo lineCoverageInfo2) {
        lineCoverageInfo1.addAll(lineCoverageInfo2);
        return lineCoverageInfo1;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        this.lineCoverageIndex.setOrMergeCoverageInfos(this.newLineCoverageInfos);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.lineCoverageIndex.removeCoverage(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.newLineCoverageInfos.clear();
    }
}

