/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeInfo;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@IndexValueClass
public class RepositoryChangeSet
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private static final Set<ERepositoryChangeType> ADD_DELETE_CHANGE_TYPES = EnumSet.of(ERepositoryChangeType.ADD, ERepositoryChangeType.DELETE);
    private final String author;
    private final String message;
    private final String revision;
    private final Map<String, RepositoryChangeInfo> changes = new HashMap<String, RepositoryChangeInfo>();
    private final IncludeExcludeAntPatternSupport patternSupport;
    private final long startTimestamp;

    public RepositoryChangeSet(String revision, String branchName, long timestamp, String author, String message, IncludeExcludeAntPatternSupport patternSupport, long startTimestamp) {
        this(revision, new CommitDescriptor(branchName, timestamp), author, message, patternSupport, startTimestamp);
    }

    public RepositoryChangeSet(String revision, CommitDescriptor commit, String author, String message, IncludeExcludeAntPatternSupport patternSupport, long startTimestamp) {
        super(commit);
        this.revision = revision;
        this.author = author;
        this.message = message;
        this.patternSupport = patternSupport;
        this.startTimestamp = startTimestamp;
    }

    public RepositoryChangeSet cloneWithoutChanges() {
        return new RepositoryChangeSet(this.revision, this.getCommit(), this.author, this.message, this.patternSupport, this.startTimestamp);
    }

    public UnmodifiableSet<String> getChangePaths() {
        return CollectionUtils.asUnmodifiable(this.changes.keySet());
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public RepositoryChangeInfo getChangeInfo(String path) {
        return this.changes.get(path);
    }

    public String getRevision() {
        return this.revision;
    }

    public void addChange(String path, ERepositoryChangeType changeType, @Nullable String originPath, @Nullable CommitDescriptor originCommit) {
        if (!this.patternSupport.isIncluded(path)) {
            return;
        }
        UniformPath originUniformPath = null;
        if (!this.isValidOriginInfo(originPath, originCommit)) {
            originCommit = null;
        } else {
            originUniformPath = UniformPath.parse((String)originPath);
        }
        RepositoryChangeInfo existingChange = this.changes.get(path);
        if (existingChange != null) {
            if (RepositoryChangeSet.isAggregatedEdit(existingChange.getChangeType(), changeType)) {
                changeType = ERepositoryChangeType.EDIT;
            } else if (ADD_DELETE_CHANGE_TYPES.contains((Object)existingChange.getChangeType())) {
                return;
            }
        }
        this.changes.put(path, new RepositoryChangeInfo(originUniformPath, originCommit, changeType));
    }

    private static boolean isAggregatedEdit(ERepositoryChangeType first, ERepositoryChangeType second) {
        return RepositoryChangeSet.isAddDeletePair(first, second) || RepositoryChangeSet.isAddDeletePair(second, first);
    }

    private static boolean isAddDeletePair(ERepositoryChangeType first, ERepositoryChangeType second) {
        return first == ERepositoryChangeType.ADD && second == ERepositoryChangeType.DELETE;
    }

    private boolean isValidOriginInfo(String originPath, CommitDescriptor originCommit) {
        if (originPath == null || originCommit == null) {
            return false;
        }
        return this.patternSupport.isIncluded(originPath) && originCommit.getTimestamp() >= this.startTimestamp;
    }

    public void addChange(String path, ERepositoryChangeType changeType) {
        this.addChange(path, changeType, null, null);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "RepositoryChangeSet [author=" + this.author + ", message=" + this.message + ", revision=" + this.revision + ", changes=" + String.valueOf(this.changes) + ", patternSupport=" + String.valueOf(this.patternSupport) + ", startTimestamp=" + this.startTimestamp + "]";
    }

    public void applyChanges(RepositoryChangeSet changeSet) {
        for (Map.Entry<String, RepositoryChangeInfo> changeEntry : changeSet.changes.entrySet()) {
            this.changes.merge(changeEntry.getKey(), changeEntry.getValue(), RepositoryChangeSet::mergeChangeInfo);
        }
    }

    private static RepositoryChangeInfo mergeChangeInfo(RepositoryChangeInfo oldInfo, RepositoryChangeInfo newInfo) {
        return switch (oldInfo.getChangeType()) {
            default -> throw new MatchException(null, null);
            case ERepositoryChangeType.ADD -> RepositoryChangeSet.mergeChangeInfoAfterAdd(newInfo);
            case ERepositoryChangeType.EDIT, ERepositoryChangeType.DELETE -> new RepositoryChangeInfo(null, null, RepositoryChangeSet.mergeChangeInfoAfterEditOrDelete(newInfo));
        };
    }

    private static RepositoryChangeInfo mergeChangeInfoAfterAdd(RepositoryChangeInfo newInfo) {
        return switch (newInfo.getChangeType()) {
            default -> throw new MatchException(null, null);
            case ERepositoryChangeType.ADD, ERepositoryChangeType.EDIT -> new RepositoryChangeInfo(null, null, ERepositoryChangeType.ADD);
            case ERepositoryChangeType.DELETE -> null;
        };
    }

    private static ERepositoryChangeType mergeChangeInfoAfterEditOrDelete(RepositoryChangeInfo newInfo) {
        return switch (newInfo.getChangeType()) {
            default -> throw new MatchException(null, null);
            case ERepositoryChangeType.ADD, ERepositoryChangeType.EDIT -> ERepositoryChangeType.EDIT;
            case ERepositoryChangeType.DELETE -> ERepositoryChangeType.DELETE;
        };
    }
}

