/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client.model.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class BitbucketCloudCommitReportAnnotation {
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="external_id")
    private String externalId;
    @JsonProperty(value="annotation_type")
    private BitbucketCloudCommitReportAnnotationType annotationType;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="line")
    private int line;
    @JsonProperty(value="summary")
    private String summary;
    @JsonProperty(value="details")
    private String details;
    @JsonProperty(value="result")
    private EBitbucketCloudReportAnnotationState result;
    @JsonProperty(value="link")
    private String link;
    @JsonProperty(value="severity")
    private EBitbucketCloudReportAnnotationSeverity severity;
    @JsonProperty(value="created_on")
    private String createdOn;
    @JsonProperty(value="updated_on")
    private String updatedOn;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public BitbucketCloudCommitReportAnnotationType getAnnotationType() {
        return this.annotationType;
    }

    private void setAnnotationType(BitbucketCloudCommitReportAnnotationType annotationType) {
        this.annotationType = annotationType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public EBitbucketCloudReportAnnotationState getAnnotationState() {
        return this.result;
    }

    public void setAnnotationState(EBitbucketCloudReportAnnotationState result) {
        this.result = result;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public EBitbucketCloudReportAnnotationSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(EBitbucketCloudReportAnnotationSeverity severity) {
        this.severity = severity;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getUpdatedOn() {
        return this.updatedOn;
    }

    public void setUpdatedOn(String updatedOn) {
        this.updatedOn = updatedOn;
    }

    @JsonCreator
    BitbucketCloudCommitReportAnnotation() {
    }

    public static BitbucketCloudCommitReportAnnotation fromReviewComment(IReviewComment reviewComment) {
        BitbucketCloudCommitReportAnnotation annotation = new BitbucketCloudCommitReportAnnotation();
        annotation.setAnnotationType(BitbucketCloudCommitReportAnnotationType.fromReviewCommentCategory(reviewComment.getCategory()));
        annotation.setSeverity(EBitbucketCloudReportAnnotationSeverity.fromTrafficLight(reviewComment.getAssessment()));
        annotation.setPath(reviewComment.getLocation().getUniformPath());
        annotation.setLine(reviewComment.getStartLine());
        Object text = reviewComment.getTextWithoutLinks();
        text = "  " + (String)text;
        annotation.setSummary((String)text);
        annotation.setDetails((String)text);
        annotation.setLink(reviewComment.getTeamscaleDetailsUrl());
        annotation.setExternalId("teamscale-annotation-" + reviewComment.hashCode());
        return annotation;
    }

    public String toString() {
        return "BitbucketCloudCommitReportAnnotation{uuid='" + this.uuid + "', externalId='" + this.externalId + "', annotationType=" + String.valueOf((Object)this.annotationType) + ", path='" + this.path + "', line=" + this.line + ", summary='" + this.summary + "', details='" + this.details + "', result=" + String.valueOf((Object)this.result) + ", link='" + this.link + "', severity=" + String.valueOf((Object)this.severity) + ", createdOn='" + this.createdOn + "', updatedOn='" + this.updatedOn + "'}";
    }

    public static enum BitbucketCloudCommitReportAnnotationType {
        VULNERABILITY,
        CODE_SMELL,
        BUG;


        public static BitbucketCloudCommitReportAnnotationType fromReviewCommentCategory(String reviewCommentCategory) {
            if (reviewCommentCategory.equals("Security")) {
                return VULNERABILITY;
            }
            return BUG;
        }
    }

    public static enum EBitbucketCloudReportAnnotationState {
        PASSED,
        FAILED,
        SKIPPED,
        PENDING;

    }

    public static enum EBitbucketCloudReportAnnotationSeverity {
        CRITICAL,
        HIGH,
        MEDIUM,
        LOW;


        public static EBitbucketCloudReportAnnotationSeverity fromTrafficLight(ETrafficLightColor trafficLightColor) {
            return switch (trafficLightColor) {
                default -> throw new MatchException(null, null);
                case ETrafficLightColor.RED -> CRITICAL;
                case ETrafficLightColor.ORANGE -> HIGH;
                case ETrafficLightColor.YELLOW, ETrafficLightColor.UNKNOWN -> MEDIUM;
                case ETrafficLightColor.GREEN, ETrafficLightColor.BASELINE -> LOW;
            };
        }
    }
}

