/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public abstract class WebHookBasedGitRepositoryConnectorDescriptorBase
extends GitRepositoryManagementConnectorDescriptorBase {
    public static final String LEGACY_MERGE_REQUEST_DISABLE_AUTOMATIC_WEBHOOK_CREATION_FLAG_NAME = "com.teamscale.mergerequest.disable-automatic-webhook-creation";
    public static final String LEGACY_FEATURE_TOGGLE_DISABLE_AUTOMATIC_WEBHOOK_CREATION_FLAG_NAME = "com.teamscale.feature-toggle.disable-automatic-webhook-creation";
    public static final String DISABLE_AUTOMATIC_WEBHOOK_CREATION_FLAG_NAME = "com.teamscale.mergerequest.disable-automatic-webhook-creation-default";
    private static final String IGNORE_WEBHOOKS_FROM_OWN_USER_FLAG_NAME = "com.teamscale.mergerequest.ignore-webhooks-from-own-user-default";
    public static final boolean LEGACY_DISABLE_AUTOMATIC_WEBHOOK_CREATION = Boolean.getBoolean("com.teamscale.mergerequest.disable-automatic-webhook-creation") || Boolean.getBoolean("com.teamscale.feature-toggle.disable-automatic-webhook-creation");
    public static final boolean DISABLE_AUTOMATIC_WEBHOOK_CREATION = Boolean.getBoolean("com.teamscale.mergerequest.disable-automatic-webhook-creation-default") || LEGACY_DISABLE_AUTOMATIC_WEBHOOK_CREATION;
    private static final boolean IGNORE_WEBHOOKS_FROM_OWN_USER = Boolean.getBoolean("com.teamscale.mergerequest.ignore-webhooks-from-own-user-default");
    @ConfigExposed(name="Disable automatic webhook creation", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="If this is set to true, Teamscale will not create the required webhooks. Instead, you are responsible to set up webhooks according to the documentation to allow proper voting.")
    protected boolean disableAutomaticWebhookCreation = DISABLE_AUTOMATIC_WEBHOOK_CREATION;
    public static final String IGNORE_WEBHOOKS_FROM_CONFIGURED_USER_OPTION_NAME = "Ignore webhooks from configured user";
    @ConfigExposed(name="Ignore webhooks from configured user", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="If this is set to true, Teamscale will ignore any webhooks triggered by the user configured in this connector, in order to avoid useless round-trips to the server. For production setups, this should be enabled and used with a dedicated build user.")
    private boolean ignoreWebhooksFromOwnUser = IGNORE_WEBHOOKS_FROM_OWN_USER;
    public static final CommitVotingTriggerBase.EFindingsBadgePosition FINDINGS_BADGE_POSITION_DEFAULT = CommitVotingTriggerBase.EFindingsBadgePosition.TOP;
    public static final String FINDINGS_BADGE_POSITION_OPTION_NAME = "Findings badge position";
    @ConfigExposed(name="Findings badge position", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="The position of where to display the findings badge in the pull request.")
    protected CommitVotingTriggerBase.EFindingsBadgePosition findingsBadgePosition = FINDINGS_BADGE_POSITION_DEFAULT;
    private final Logger interactionLogger;

    protected WebHookBasedGitRepositoryConnectorDescriptorBase(ERepositoryConnector type, Logger interactionLogger) {
        super(type);
        this.interactionLogger = interactionLogger;
        this.autoExpose();
        if (!this.enableIgnoreWebhooksFromUserOption()) {
            this.hideOption(IGNORE_WEBHOOKS_FROM_CONFIGURED_USER_OPTION_NAME);
        }
    }

    protected boolean enableIgnoreWebhooksFromUserOption() {
        return false;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (this.disableAutomaticWebhookCreation != DISABLE_AUTOMATIC_WEBHOOK_CREATION) {
            this.interactionLogger.info("There is a discrepancy in the 'Disable automatic webhook creation': The JVM flag is '{}' while the project-specific setting is '{}'", (Object)DISABLE_AUTOMATIC_WEBHOOK_CREATION, (Object)this.disableAutomaticWebhookCreation);
        }
        try {
            if (BaseUrlOption.getBaseUrl((ServerOptionIndex)((ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class))) == null) {
                throw new ConnectorValidationException("Instance Base URL not configured! Please ask your Teamscale administrator to configure the base URL.");
            }
        }
        catch (StorageException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        try {
            if (!this.disableAutomaticWebhookCreation) {
                this.ensureHookIsConfigured((ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class));
            }
        }
        catch (ServiceCallException | IOException | StorageException e) {
            throw new ProjectConfigurationException(e);
        }
        super.configureTriggers(triggerCreator);
    }

    @Override
    protected void setPullRequestSynchronizerParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        super.setPullRequestSynchronizerParameters(trigger);
        trigger.setTriggerParameter("account-identifier", this.getAccountIdentifier());
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter("repository-path", this.getRepositoryUri().toString());
    }

    protected abstract void ensureHookIsConfigured(ServerOptionIndex var1) throws StorageException, ServiceCallException, IOException, ConnectorValidationException;
}

