/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.version.Version;

public final class AppBasedGithubConnectorValidationUtils {
    public static void checkUserIsCollaborator(GitHubApplicationDescription applicationDescription, String password, PlatformRepositoryIdentifier repositoryId, ConfigurationInitializationContext context, Logger interactionLogger) throws ConnectorValidationException {
        if (context.getReason() != ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION || applicationDescription.skipCollaboratorCheck) {
            return;
        }
        if (context.getUsername().isEmpty()) {
            throw new ConnectorValidationException("May not create GitHub connector from a context without username!");
        }
        AppBasedGithubConnectorValidationUtils.checkUserIsCollaborator(applicationDescription, password, repositoryId, (String)context.getUsername().get(), interactionLogger);
    }

    public static void checkUserIsCollaborator(GitHubApplicationDescription applicationDescription, String password, PlatformRepositoryIdentifier repositoryId, String username, Logger interactionLogger) throws ConnectorValidationException {
        GitHubPullRequestClient client = new GitHubPullRequestClient(applicationDescription, password, interactionLogger);
        try {
            if (!client.isUserCollaborator(repositoryId, username)) {
                throw new ConnectorValidationException("Your user " + username + " is not a collaborator for repository " + String.valueOf(repositoryId) + " and thus is not allowed to create a Teamscale project for it!");
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Determining collaborators failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void checkServerVersion(GitHubApplicationDescription applicationDescription, String password, BiFunction<Version, String, Boolean> isOutdated, Logger interactionLogger) throws ConnectorValidationException {
        if (applicationDescription.isPublicGitHub()) {
            return;
        }
        GitHubPullRequestClient client = new GitHubPullRequestClient(applicationDescription, password, interactionLogger);
        try {
            Version minimumVersion = new Version(2, 14);
            String version = client.getMetaInfoForEnterpriseInstance().installedVersion();
            if (isOutdated.apply(minimumVersion, version).booleanValue()) {
                throw new ConnectorValidationException("Minimum required GitHub Enterprise version is 2.14.0. Please update your server from version " + version + " to be able to use this connector.");
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Determining GitHub's instance version failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private AppBasedGithubConnectorValidationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

