/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.scm_manager.ScmManagerClient;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestProvider;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerCiStatus;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerDiff;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequestComments;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequests;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ScmManagerMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<ScmManagerPullRequests.PullRequest, MergeRequestBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ScmManagerClient client;
    private ExternalCredentials credentials;
    private PlatformRepositoryIdentifier repositoryIdentifier;

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.SCM_MANAGER;
    }

    @Override
    protected MergeRequestProvider<ScmManagerPullRequests.PullRequest, MergeRequestBuildJob> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        this.credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        this.client = new ScmManagerClient(this.credentials, LOGGER);
        String repositoryName = ScmManagerMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector());
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        return new ScmManagerMergeRequestProvider(repositoryName, this.client);
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws ServiceCallException {
        this.client.updateFindingsBadge(this.repositoryIdentifier, input.mergeRequest.getId(), badgeAsMarkdown);
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        ScmManagerCiStatus.CiStatus status = ScmManagerUtils.buildCiStatus(findingsVotingInfo, input.createMergeRequestDetailsLink(schedulingParams.linkProvider()));
        this.client.putCiStatus(this.repositoryIdentifier, status, input.mergeRequest.getId());
        return findingsVotingInfo.isPositiveVote() ? VotingRecord.EVotingState.VOTED_POSITIVE : VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) throws ServiceCallException {
        this.deleteExistingTeamscaleComments(input, comment -> this.isFindingComment((ScmManagerPullRequestComments.PullRequestComment)comment) || this.isMarkdownTestGapComment((ScmManagerPullRequestComments.PullRequestComment)comment));
        this.postNewTeamscaleComments(input, reviewComments);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteExistingTeamscaleComments(input, this::isListOfMarkdownTestGapComments);
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException {
        this.client.postPullRequestComment(this.repositoryIdentifier, pullRequestId, new ScmManagerPullRequestComments.PullRequestComment(commentContent));
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException {
        Object badgeAsMarkdown = this.client.getFindingsBadeAsMarkdown(this.repositoryIdentifier, input.mergeRequest.getId());
        badgeAsMarkdown = (String)badgeAsMarkdown + "\n" + commentLimitWarningExceededMessage;
        this.client.updateFindingsBadge(this.repositoryIdentifier, input.mergeRequest.getId(), (String)badgeAsMarkdown);
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteExistingTeamscaleComments(input, this::isFindingComment);
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteExistingTeamscaleComments(input, this::isMarkdownTestGapComment);
    }

    private void deleteExistingTeamscaleComments(MergeRequestAnnotationInput input, Predicate<ScmManagerPullRequestComments.PullRequestComment> commentFilter) throws ServiceCallException {
        List<ScmManagerPullRequestComments.PullRequestComment> existingComments = this.client.getPullRequestComments(this.repositoryIdentifier, input.mergeRequest.getId());
        List teamscaleComments = CollectionUtils.filter(existingComments, commentFilter);
        for (ScmManagerPullRequestComments.PullRequestComment comment : teamscaleComments) {
            List<ScmManagerPullRequestComments.PullRequestComment> replies = comment.getEmbeddedPullRequestComments().getReplies();
            if (replies != null && !replies.isEmpty()) continue;
            this.deleteComment(input.mergeRequest.getId(), comment);
        }
    }

    private boolean isFindingComment(ScmManagerPullRequestComments.PullRequestComment comment) {
        return comment.getAuthor().id().equals(this.credentials.username) && !this.isCommitAlertComment(comment) && !this.isMarkdownTestGapComment(comment);
    }

    private boolean isCommitAlertComment(ScmManagerPullRequestComments.PullRequestComment comment) {
        return comment.getAuthor().id().equals(this.credentials.username) && comment.getComment().startsWith("**[Alert]** ");
    }

    private boolean isMarkdownTestGapComment(ScmManagerPullRequestComments.PullRequestComment comment) {
        return comment.getAuthor().id().equals(this.credentials.username) && CcpCommentUtils.isMarkdownTeamscaleTestGapComment(comment.getComment());
    }

    private boolean isListOfMarkdownTestGapComments(ScmManagerPullRequestComments.PullRequestComment comment) {
        return comment.getAuthor().id().equals(this.credentials.username) && CcpCommentUtils.isTeamscaleTestGapSummaryComment(comment.getComment());
    }

    private void deleteComment(long mergeRequestId, ScmManagerPullRequestComments.PullRequestComment comment) throws ServiceCallException {
        for (ScmManagerPullRequestComments.PullRequestComment reply : comment.getEmbeddedPullRequestComments().getReplies()) {
            this.deleteComment(mergeRequestId, reply);
        }
        this.client.deletePullRequestComment(this.repositoryIdentifier, mergeRequestId, comment.getId());
    }

    private void postNewTeamscaleComments(MergeRequestAnnotationInput input, List<IReviewComment> reviewComments) throws ServiceCallException {
        ScmManagerDiff.Diff diff = this.client.getPullRequestDiff(this.repositoryIdentifier, input.mergeRequest.sourceBranch, input.mergeRequest.targetBranch);
        List<ScmManagerPullRequestComments.PullRequestComment> commentsToBeAdded = ScmManagerUtils.createInlineCommentsFromFindings(reviewComments, diff);
        for (ScmManagerPullRequestComments.PullRequestComment comment : commentsToBeAdded) {
            try {
                this.client.postPullRequestComment(this.repositoryIdentifier, input.mergeRequest.getId(), comment);
            }
            catch (ServiceCallException e) {
                LOGGER.error("Posting pull request comment failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

