/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match.name;

import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class PathEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final HashMap<String, Pair<Long, Long>> pathTimestampMap = new HashMap();

    public PathEntry(String path, long timestamp) {
        this.fileName = PathByNameIndex.extractNameFromPath(path);
        this.addPathWithTimestamp(path, timestamp);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addPathWithTimestamp(String path, long timestamp) {
        if (!this.pathTimestampMap.containsKey(path) || this.pathTimestampMap.get(path).getSecond() != null) {
            this.pathTimestampMap.put(path, (Pair<Long, Long>)new Pair((Object)timestamp, null));
        }
    }

    public Set<String> getAllPaths() {
        return this.pathTimestampMap.keySet();
    }

    public void markPathAsDeleted(String path, long timestamp) {
        Pair<Long, Long> timestamps = this.pathTimestampMap.get(path);
        if (timestamps == null) {
            return;
        }
        timestamps.setSecond((Object)timestamp);
    }

    public Long getAddedTimestamp(String fullPath) {
        Pair<Long, Long> timestampPair = this.pathTimestampMap.get(fullPath);
        if (timestampPair == null) {
            return null;
        }
        return (Long)timestampPair.getFirst();
    }

    public Long getDeletedTimestamp(String fullPath) {
        Pair<Long, Long> timestampPair = this.pathTimestampMap.get(fullPath);
        if (timestampPair == null) {
            return null;
        }
        return (Long)timestampPair.getSecond();
    }
}

