/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import java.io.Serializable;
import java.util.Objects;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class SvnExternalTarget
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String localPath;
    private final String repositoryRoot;
    private final String repositorySuffix;
    private final long fixedRevision;

    public SvnExternalTarget(String localPath, String repositoryRoot, String repositorySuffix, long fixedRevision) {
        this.localPath = SvnExternalTarget.trimSlashes(localPath);
        this.repositoryRoot = SvnExternalTarget.ensureTrailingSlash(repositoryRoot);
        this.repositorySuffix = SvnExternalTarget.trimSlashes(repositorySuffix);
        this.fixedRevision = fixedRevision;
    }

    private static String ensureTrailingSlash(String path) {
        return StringUtils.ensureEndsWith((String)path, (String)"/");
    }

    public static String trimSlashes(String path) {
        if (path == null) {
            return null;
        }
        return StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)path, (String)"/"), (String)"/");
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getRepositorySuffix() {
        return this.repositorySuffix;
    }

    public long getFixedRevision() {
        return this.fixedRevision;
    }

    public String resolveWcToServerPath(String workingCopyPath) {
        return SvnExternalTarget.trimSlashes(UniformPathUtils.concatenate((String[])new String[]{this.repositorySuffix, SvnExternalTarget.trimSlashes(StringUtils.stripPrefix((String)SvnExternalTarget.trimSlashes(workingCopyPath), (String)this.localPath))}));
    }

    public boolean containsServerPath(String serverPath) {
        String trimmedServerPath = SvnExternalTarget.trimSlashes(serverPath);
        return this.repositorySuffix.isEmpty() || this.repositorySuffix.equals(trimmedServerPath) || trimmedServerPath.startsWith(this.repositorySuffix + "/");
    }

    public String resolveServerToWcPath(String serverPath) {
        return SvnExternalTarget.trimSlashes(UniformPathUtils.concatenate((String[])new String[]{this.localPath, SvnExternalTarget.trimSlashes(StringUtils.stripPrefix((String)SvnExternalTarget.trimSlashes(serverPath), (String)this.repositorySuffix))}));
    }

    public boolean hasFixedRevision() {
        return this.fixedRevision != 0L;
    }

    public SvnExternalTarget copyWithPrefixedLocalPath(String prefix) {
        String newLocalPath = UniformPathUtils.concatenate((String[])new String[]{SvnExternalTarget.trimSlashes(prefix), this.localPath});
        return new SvnExternalTarget(newLocalPath, this.repositoryRoot, this.repositorySuffix, this.fixedRevision);
    }

    public String toString() {
        return "ExternalTarget [localPath=" + this.localPath + ", repositoryRoot=" + this.repositoryRoot + ", repositorySuffix=" + this.repositorySuffix + ", fixedRevision=" + this.fixedRevision + "]";
    }

    public int hashCode() {
        return Objects.hash(this.localPath, this.repositoryRoot, this.repositorySuffix, this.fixedRevision);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SvnExternalTarget)) {
            return false;
        }
        SvnExternalTarget target = (SvnExternalTarget)other;
        return this.localPath.equals(target.localPath) && this.repositoryRoot.equals(target.repositoryRoot) && this.repositorySuffix.equals(target.repositorySuffix) && this.fixedRevision == target.fixedRevision;
    }
}

