/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request;

import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureAssessmentInfoUtils;
import com.teamscale.index.architecture.assessment.ArchitectureAnnotator;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureComponentDependencyIndex;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.incremental.DependencyValueClass;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.merge_request.ArchitectureComponentSpecItemDelta;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemMappingToIdsEvaluator;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

public class ArchitectureComponentSpecItemMapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RepositoryLogIndex repositoryLogIndex;
    private final ProjectStorageSystem projectStorageSystem;
    private final TokenElementIndex tokenElementIndexAtSourceHead;
    private final ArchitectureAssessmentIndex architectureAssessmentIndexAtSourceHead;
    private final SpecItemIndex specItemIndex;
    private final SpecItemMappingToIdsEvaluator specItemMappingToIdsEvaluator;
    private final MergeBaseInfo mergeBaseInfo;
    private final ArchitectureTypeDependenciesIndex architectureTypeDependenciesIndex;
    private final ArchitectureComponentDependencyIndex architectureComponentDependencyIndex;
    private final ArchitectureMappingIndex architectureMappingIndex;

    public ArchitectureComponentSpecItemMapper(HistoryAccessOption historyAccessOptionAtSourceHead, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, MergeBaseInfo mergeBaseInfo, String branchName) throws StorageException {
        this.repositoryLogIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        this.projectStorageSystem = projectStorageSystem;
        this.specItemIndex = (SpecItemIndex)projectStorageSystem.openProjectIndex(SpecItemIndex.class, historyAccessOptionAtSourceHead);
        this.tokenElementIndexAtSourceHead = (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", historyAccessOptionAtSourceHead);
        this.architectureAssessmentIndexAtSourceHead = (ArchitectureAssessmentIndex)projectStorageSystem.openProjectIndex(ArchitectureAssessmentIndex.class, historyAccessOptionAtSourceHead);
        this.specItemMappingToIdsEvaluator = new SpecItemMappingToIdsEvaluator((SpecItemHistoryIndex)projectStorageSystem.openProjectIndex(SpecItemHistoryIndex.class, null), globalStorageSystem, projectStorageSystem, null, branchName);
        this.architectureTypeDependenciesIndex = (ArchitectureTypeDependenciesIndex)projectStorageSystem.openProjectIndex(ArchitectureTypeDependenciesIndex.class, historyAccessOptionAtSourceHead);
        this.architectureComponentDependencyIndex = (ArchitectureComponentDependencyIndex)projectStorageSystem.openProjectIndex(ArchitectureComponentDependencyIndex.class, historyAccessOptionAtSourceHead);
        this.architectureMappingIndex = (ArchitectureMappingIndex)projectStorageSystem.openProjectIndex(ArchitectureMappingIndex.class, historyAccessOptionAtSourceHead);
        this.mergeBaseInfo = mergeBaseInfo;
    }

    public List<ArchitectureComponentSpecItemDelta> computeArchitectureComponentSpecItemDelta() throws StorageException {
        ArrayList<ArchitectureComponentSpecItemDelta> deltas = new ArrayList<ArchitectureComponentSpecItemDelta>();
        List<TokenElementChurnWithOriginInfo> churnInfos = this.determineChurnInfos();
        List<ArchitectureDefinition> architectureDefinitions = this.getArchitectureDefinitions();
        for (ArchitectureDefinition architecture : architectureDefinitions) {
            this.annotateArchitecture(architecture);
            for (ComponentNode component : architecture.getAllComponents()) {
                Optional<ArchitectureComponentSpecItemDelta> componentDelta = this.computeArchitectureComponentSpecItemDelta(architecture, component, churnInfos);
                componentDelta.ifPresent(deltas::add);
            }
        }
        return deltas;
    }

    private Optional<ArchitectureComponentSpecItemDelta> computeArchitectureComponentSpecItemDelta(ArchitectureDefinition architecture, ComponentNode component, List<TokenElementChurnWithOriginInfo> churnInfos) throws StorageException {
        String specItemMapping = component.getSpecItemMapping();
        Set<String> componentMatchedTypes = component.getMatchedTypes();
        if (StringUtils.isEmpty((String)specItemMapping) || componentMatchedTypes.isEmpty()) {
            return Optional.empty();
        }
        List<TeamscaleIssueId> componentMatchedSpecItemIds = this.specItemMappingToIdsEvaluator.evaluateMapping(component.getName(), component.getSpecItemMapping());
        if (componentMatchedSpecItemIds.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> uniformPaths = new ArrayList<String>();
        HashSet<EElementHistoryChangeType> repositoryChangeTypes = new HashSet<EElementHistoryChangeType>();
        ArchitectureComponentSpecItemMapper.matchComponentToMergeRequestChurn(componentMatchedTypes, churnInfos, uniformPaths, repositoryChangeTypes);
        if (uniformPaths.isEmpty()) {
            return Optional.empty();
        }
        List<SpecItem> componentMatchedSpecItems = this.specItemIndex.getIssues(componentMatchedSpecItemIds);
        return Optional.of(new ArchitectureComponentSpecItemDelta(architecture.getName(), component.getName(), uniformPaths, repositoryChangeTypes, specItemMapping, ArchitectureComponentSpecItemMapper.determineTypeInfos(componentMatchedSpecItems), componentMatchedSpecItems.size(), new HashSet<TeamscaleIssueId>(componentMatchedSpecItemIds)));
    }

    private static Set<TeamscaleIssueTypeInfo> determineTypeInfos(List<SpecItem> componentMatchedSpecItems) {
        return componentMatchedSpecItems.stream().map(SpecItem::getTypeInfo).collect(Collectors.toSet());
    }

    private static void matchComponentToMergeRequestChurn(Set<String> componentMatchedTypes, List<TokenElementChurnWithOriginInfo> churnInfos, List<String> uniformPaths, Set<EElementHistoryChangeType> repositoryChangeTypes) {
        for (TokenElementChurnWithOriginInfo churnInfo : churnInfos) {
            if (!componentMatchedTypes.contains(churnInfo.getUniformPath())) continue;
            uniformPaths.add(churnInfo.getUniformPath());
            repositoryChangeTypes.add(churnInfo.getChangeType());
        }
    }

    private void annotateArchitecture(ArchitectureDefinition architecture) throws StorageException {
        SetMap dependencies = new SetMap();
        if (!architecture.isFileBased()) {
            Map<String, ListMap<String, ElementLocation>> dependencies1 = this.architectureTypeDependenciesIndex.getDependencyLocations();
            for (Map.Entry<String, ListMap<String, ElementLocation>> entry : dependencies1.entrySet()) {
                dependencies.addAll((Object)entry.getKey(), (Collection)entry.getValue().getKeys());
            }
        }
        List<DependencyValueClass> dtos = this.architectureComponentDependencyIndex.getDependencies(architecture.getName());
        TypeComponentMapping mapping = this.architectureMappingIndex.getMapping(architecture.getName());
        if (mapping == null) {
            return;
        }
        List<Dependency> deps = ArchitectureAnalysisUtils.convertDependencyObjects(architecture, dtos);
        ArchitectureAnnotator architectureAnnotator = new ArchitectureAnnotator(architecture, mapping, deps);
        architectureAnnotator.assess();
        try {
            architectureAnnotator.annotateArchitectureWithResult();
        }
        catch (ConQATException ex) {
            LOGGER.error("Annotating architecture {} failed.", (Object)architecture.getName(), (Object)ex);
        }
    }

    private List<TokenElementChurnWithOriginInfo> determineChurnInfos() throws StorageException {
        List<CommitDescriptor> relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest(this.repositoryLogIndex, this.mergeBaseInfo);
        return AffectedFilesUtils.getAffectedCodeFiles(this.projectStorageSystem, relevantCommits);
    }

    private List<ArchitectureDefinition> getArchitectureDefinitions() throws StorageException {
        PairList<String, ArchitectureAssessmentInfo> allArchitecturePathsAtSourceHead = this.architectureAssessmentIndexAtSourceHead.getAllAssessments();
        return ArchitectureAssessmentInfoUtils.getArchitectureDefinitions((List<String>)allArchitecturePathsAtSourceHead.getFirstList(), this.tokenElementIndexAtSourceHead);
    }
}

