/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer;

import com.polarion.alm.ws.client.types.tracker.Module;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionQueryBuilder;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionImportConfiguration;
import java.util.List;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.concurrent.FutureWithException;

class PolarionWorkItemHandlerBase {
    protected final PolarionImportConfiguration configuration;

    protected PolarionWorkItemHandlerBase(PolarionImportConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Stream<WorkItem> retrieveUpdatedWorkItems(@NonNull Module module, long lastScanTimestamp) throws PolarionServerException, InterruptedException {
        CCSMAssert.isNotNull((Object)module, () -> String.format("Expected \"%s\" to be not null", "module"));
        return this.fetchWorkItems(module, lastScanTimestamp, this.configuration.getAllFieldIdsToBeFetched());
    }

    protected Stream<WorkItem> fetchWorkItems(@NonNull Module module, @Nullable Long lastScanTimestamp, @NonNull String[] fieldsToFill) throws PolarionServerException, InterruptedException {
        String query = PolarionWorkItemHandlerBase.buildQuery(module, lastScanTimestamp);
        return (Stream)this.fetchWorkItems(query, fieldsToFill).getWithException();
    }

    private static String buildQuery(@NonNull Module module, @Nullable Long lastScanTimestamp) {
        PolarionQueryBuilder queryBuilder = new PolarionQueryBuilder().withModuleId(module.getModuleFolder(), List.of(module.getId()));
        if (lastScanTimestamp != null) {
            queryBuilder.and().updatedAfter(lastScanTimestamp);
        }
        return queryBuilder.build();
    }

    private FutureWithException<Stream<WorkItem>, PolarionServerException> fetchWorkItems(String query, String[] fieldsToFill) {
        return this.configuration.getServiceClient().queryWorkItems(query, fieldsToFill).then(items -> items.stream().filter(workItem -> workItem.getType() != null && this.configuration.getIncludedWorkItemTypeIdToName().containsKey(workItem.getType().getId())));
    }
}

