/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.azure_devops;

import com.teamscale.wia.ManualTestCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AzureDevOpsTestStepsParser {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ManualTestCase.TestStep> parseTestSteps(String testStepSpecification) {
        if (StringUtils.isEmpty((String)testStepSpecification)) {
            return Collections.emptyList();
        }
        testStepSpecification = AzureDevOpsTestStepsParser.preprocessTestStepsSpecification(testStepSpecification);
        Document testStepsHtml = Jsoup.parse((String)testStepSpecification);
        ArrayList<ManualTestCase.TestStep> steps = new ArrayList<ManualTestCase.TestStep>();
        for (Element stepElement : testStepsHtml.getElementsByTag("step")) {
            ManualTestCase.TestStep step = AzureDevOpsTestStepsParser.parseTestStep(stepElement);
            if (step == null) continue;
            steps.add(step);
        }
        return steps;
    }

    private static String preprocessTestStepsSpecification(String testStepSpecification) {
        return testStepSpecification.replaceAll("<compref([^>]*)>", "<step$1 type=\"SharedStep\"/>").replace("</compref>", "");
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ManualTestCase.TestStep parseTestStep(Element stepElement) {
        String stepType;
        switch (stepType = stepElement.attr("type")) {
            case "ActionStep": {
                return AzureDevOpsTestStepsParser.parseActionStep(stepElement);
            }
            case "ValidateStep": {
                return AzureDevOpsTestStepsParser.parseValidateStep(stepElement);
            }
            case "SharedStep": {
                return AzureDevOpsTestStepsParser.parseSharedStep(stepElement);
            }
        }
        LOGGER.warn("Unknown step type {}, ignoring step ", (Object)stepElement);
        return null;
    }

    private static ManualTestCase.TestStep parseSharedStep(Element stepElement) {
        String referencedStepId = stepElement.attr("ref");
        return new ManualTestCase.TestStep("Shared Steps " + referencedStepId, "");
    }

    private static ManualTestCase.TestStep parseValidateStep(Element stepElement) {
        return AzureDevOpsTestStepsParser.parseNormalStep(stepElement, ManualTestCase.TestStep::ofCheck);
    }

    private static ManualTestCase.TestStep parseActionStep(Element stepElement) {
        return AzureDevOpsTestStepsParser.parseNormalStep(stepElement, ManualTestCase.TestStep::ofAction);
    }

    private static ManualTestCase.TestStep parseNormalStep(Element stepElement, Function<String, ManualTestCase.TestStep> singleElementStepFactory) {
        Elements stepPartElements = stepElement.getElementsByTag("parameterizedString");
        switch (stepPartElements.size()) {
            case 1: {
                Element singleElement = (Element)stepPartElements.get(0);
                String elementText = AzureDevOpsTestStepsParser.getStepText(singleElement);
                return singleElementStepFactory.apply(elementText);
            }
            case 2: {
                String actionText = AzureDevOpsTestStepsParser.getStepText((Element)stepPartElements.get(0));
                String checkText = AzureDevOpsTestStepsParser.getStepText((Element)stepPartElements.get(1));
                return new ManualTestCase.TestStep(actionText, checkText);
            }
        }
        LOGGER.warn("Unable to parse test step: " + String.valueOf(stepPartElements));
        return null;
    }

    private static String getStepText(@Nullable Element element) {
        if (element == null) {
            return "";
        }
        return AzureDevOpsTestStepsParser.normalizeStepText(element.wholeText());
    }

    private static String normalizeStepText(String text) {
        return Jsoup.parse((String)text).wholeText().strip();
    }
}

