/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.ContainerSynchronizerBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;

public abstract class VirtualFileSystemContainerIndexSynchronizerBase
extends ContainerSynchronizerBase {
    public static final String REDIRECT_HASH_PREFIX = "redirect:";

    @Override
    protected List<String> getAddedOrChangedFiles() throws StorageException {
        ListMap map = this.getMetricsIndex().rawIndexKeysToPartitionToUniformMap(this.getMetricsDelta().getAddedOrChangedKeysAsBytes());
        return new ArrayList<String>(new HashSet(map.getValues()));
    }

    @Override
    protected List<String> getDeletedKeys() throws StorageException {
        Set uniformPaths = this.getMetricsIndex().rawIndexKeysToUniformPaths(CollectionUtils.map((Collection)this.getMetricsDelta().getDeletedKeys(), StorageKey::getKey));
        return new ArrayList<String>(uniformPaths);
    }

    @Override
    protected List<String> getContentHashesForAddedOrChangedKeys(List<String> addedOrChangedKeys) {
        ArrayList<String> hashes = new ArrayList<String>();
        for (String key : addedOrChangedKeys) {
            hashes.add(VirtualFileSystemContainerIndexSynchronizerBase.getHash(this.cleanKey(key)));
        }
        return hashes;
    }

    private static String getHash(String path) {
        return REDIRECT_HASH_PREFIX + path;
    }

    protected abstract String cleanKey(String var1);

    protected abstract KeyDelta getMetricsDelta();

    protected abstract MetricsIndex getMetricsIndex();
}

