/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.retrieval_strategy.StoredQueryMetricRetrievalStrategyBase;
import com.teamscale.wia.TeamscaleIssue;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class IssueQueryMetricRetrievalStrategy
extends StoredQueryMetricRetrievalStrategyBase {
    public IssueQueryMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser) {
        super(projectStorageSystem, globalStorageSystem, currentUser, StoredQueryIndex.EStoredQueryType.ISSUE);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        WorkItemHistoryIndexAggregation<TeamscaleIssue> indexAggregation = WorkItemHistoryIndexAggregation.forIssues(this.projectStorageSystem, historyAccessOption);
        List<String> issueIds = this.getIssueIds(uniformPath, indexAggregation, historyAccessOption);
        if (issueIds == null) {
            return null;
        }
        return IssueQueryMetricRetrievalStrategy.getMetricDirectoryEntry(issueIds, uniformPath, 1);
    }

    @Override
    protected String getBasicMetricName() {
        return "Issues";
    }

    protected WorkItemHistoryIndexAggregation<TeamscaleIssue> getHistoryIndex(CommitDescriptor commit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forIssues(this.projectStorageSystem, commit);
    }
}

