/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.ProcessCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.auth.oauth2.GoogleCredentials;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.s3.CredentialsProcess;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.IS3ClientFactory;
import com.teamscale.index.s3.S3Client;
import com.teamscale.index.s3.S3RegionUtils;
import com.teamscale.index.s3.S3UriParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class S3ClientFactory
implements IS3ClientFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private @Nullable Map<String, IS3Client> clientOverwritesByUris = null;

    public static S3ClientFactory getInstance() {
        return Singleton.INSTANCE.instance;
    }

    @Override
    public IS3Client createForUri(IExternalCredentialsProvider externalCredentialsProvider, S3UriParser.ParsedUri parsedUri) throws StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("externalCredentialsProvider='{}', parsedUri='{}'", new Object[]{externalCredentialsProvider, parsedUri});
        if (this.clientOverwritesByUris != null && this.clientOverwritesByUris.containsKey(parsedUri.getEndpoint())) {
            return (IS3Client)LOGGER.traceExit(entryMessage, (Object)this.clientOverwritesByUris.get(parsedUri.getEndpoint()));
        }
        if (parsedUri.isGlobalS3Uri()) {
            return (IS3Client)LOGGER.traceExit(entryMessage, (Object)S3ClientFactory.createWithDefaultCredentialProvider());
        }
        return (IS3Client)LOGGER.traceExit(entryMessage, (Object)S3ClientFactory.createFromParsedUri(parsedUri, externalCredentialsProvider));
    }

    @Override
    public IS3Client createWithCredentialsProcess(String baseUri, CredentialsProcess credentialsProcess) {
        EntryMessage entryMessage = LOGGER.traceEntry("baseUri='{}', credentialsProcess='{}'", new Object[]{baseUri, credentialsProcess});
        if (this.clientOverwritesByUris != null && this.clientOverwritesByUris.containsKey(baseUri)) {
            return (IS3Client)LOGGER.traceExit(entryMessage, (Object)this.clientOverwritesByUris.get(baseUri));
        }
        return (IS3Client)LOGGER.traceExit(entryMessage, (Object)new S3Client(baseUri, (AWSCredentialsProvider)ProcessCredentialsProvider.builder().withCommand(credentialsProcess.createCommand()).build()));
    }

    @Override
    @TestOnly
    public synchronized void registerClientForTesting(String uri, @Nullable IS3Client client) throws IllegalStateException {
        EntryMessage entryMessage = LOGGER.traceEntry("uri='{}', client='{}'", new Object[]{uri, client});
        if (this.clientOverwritesByUris == null) {
            this.clientOverwritesByUris = new HashMap<String, IS3Client>();
        }
        if (client == null) {
            this.clientOverwritesByUris.remove(uri);
            LOGGER.traceExit(entryMessage);
            return;
        }
        if (this.clientOverwritesByUris.containsKey(uri)) {
            throw (IllegalStateException)LOGGER.traceExit(entryMessage, (Object)new IllegalStateException("Client already registered for URI '%s'.".formatted(uri)));
        }
        this.clientOverwritesByUris.put(uri, client);
        LOGGER.traceExit(entryMessage);
    }

    private static IS3Client createWithDefaultCredentialProvider() {
        EntryMessage entryMessage = LOGGER.traceEntry();
        DefaultAWSCredentialsProviderChain credentialsProvider = new DefaultAWSCredentialsProviderChain();
        return (IS3Client)LOGGER.traceExit(entryMessage, (Object)new S3Client(() -> ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider))).build(), (AWSCredentialsProvider)credentialsProvider));
    }

    @VisibleForTesting
    static IS3Client createFromParsedUri(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider externalCredentialsProvider) throws StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("parsedUri='{}', externalCredentialsProvider='{}'", new Object[]{parsedUri, externalCredentialsProvider});
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enablePathStyleAccess();
        AWSCredentials credentials = S3ClientFactory.createCredentials(parsedUri, externalCredentialsProvider);
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider(credentials);
        builder.withCredentials((AWSCredentialsProvider)credentialsProvider);
        if (credentials instanceof AnonymousAWSCredentials && parsedUri.isGoogleCloudStorageUri()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = GoogleCloudAuthenticationHandler.class::getSimpleName;
            supplierArray[1] = () -> credentials.getClass().getSimpleName();
            LOGGER.trace("Adding '{}' for credentials '{}'.", supplierArray);
            builder.withRequestHandlers(new RequestHandler2[]{GoogleCloudAuthenticationHandler.getApplicationDefault()});
        }
        return (IS3Client)LOGGER.traceExit(entryMessage, (Object)new S3Client(() -> ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(parsedUri.getEndpoint(), S3RegionUtils.extractRegionFromBaseUri(parsedUri.getEndpoint()))))).build(), (AWSCredentialsProvider)credentialsProvider));
    }

    @VisibleForTesting
    static AWSCredentials createCredentials(S3UriParser.ParsedUri parsedUri, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        ExternalCredentials externalCredentials;
        EntryMessage entryMessage = LOGGER.traceEntry("parsedUri='{}', credentialsProvider='{}'", new Object[]{parsedUri, credentialsProvider});
        if (parsedUri.getAccessKey() != null && parsedUri.getSecretKey() != null) {
            return (AWSCredentials)LOGGER.traceExit(entryMessage, (Object)new BasicAWSCredentials(parsedUri.getAccessKey(), parsedUri.getSecretKey()));
        }
        if (credentialsProvider != null && S3ClientFactory.hasMatchingCredentials(parsedUri, externalCredentials = credentialsProvider.getExternalCredentials(parsedUri.getEndpoint()))) {
            CCSMAssert.isNotNull((Object)externalCredentials);
            return (AWSCredentials)LOGGER.traceExit(entryMessage, (Object)new BasicAWSCredentials(externalCredentials.username, externalCredentials.password));
        }
        return (AWSCredentials)LOGGER.traceExit(entryMessage, (Object)new AnonymousAWSCredentials());
    }

    private static boolean hasMatchingCredentials(S3UriParser.ParsedUri parsedUri, ExternalCredentials externalCredentials) {
        EntryMessage entryMessage = LOGGER.traceEntry();
        if (externalCredentials == null) {
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
        }
        try {
            S3UriParser.ParsedUri parsedExternalCredentialsUri = S3UriParser.parseUri(new URI(externalCredentials.uri));
            return parsedUri.getEndpoint().equals(parsedExternalCredentialsUri.getEndpoint());
        }
        catch (URISyntaxException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log("Sanity check failed: The external credentials URI '{}' is not a valid URI. Cannot complete sanity check for endpoint '{}'.", (Object)externalCredentials.uri, (Object)parsedUri.getEndpoint());
            return (Boolean)LOGGER.traceExit(entryMessage, (Object)false);
        }
    }

    private static enum Singleton {
        INSTANCE(new S3ClientFactory());

        private final S3ClientFactory instance;

        private Singleton(S3ClientFactory instance) {
            this.instance = instance;
        }
    }

    @VisibleForTesting
    static final class GoogleCloudAuthenticationHandler
    extends RequestHandler2 {
        private final GoogleCredentials credentials;

        public GoogleCloudAuthenticationHandler(GoogleCredentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
        }

        public static GoogleCloudAuthenticationHandler getApplicationDefault() {
            EntryMessage entryMessage = LOGGER.traceEntry();
            try {
                return (GoogleCloudAuthenticationHandler)((Object)LOGGER.traceExit(entryMessage, (Object)new GoogleCloudAuthenticationHandler(GoogleCredentials.getApplicationDefault())));
            }
            catch (IOException e) {
                throw (UncheckedIOException)LOGGER.traceExit(entryMessage, (Object)new UncheckedIOException("Failed to create Google Cloud credentials", e));
            }
        }

        public void beforeAttempt(HandlerBeforeAttemptContext context) {
            EntryMessage entryMessage = LOGGER.traceEntry("{} for request '{}' with parameters '{}'.", new Supplier[]{() -> context, () -> context.getRequest().getEndpoint(), () -> context.getRequest().getParameters()});
            super.beforeAttempt(context);
            try {
                context.getRequest().addHeader("Authorization", "Bearer " + this.getToken());
                LOGGER.traceExit(entryMessage);
            }
            catch (IOException e) {
                throw (UncheckedIOException)LOGGER.traceExit(entryMessage, (Object)new UncheckedIOException("Failed to obtain Google Cloud token", e));
            }
        }

        private String getToken() throws IOException {
            EntryMessage entryMessage = LOGGER.traceEntry();
            String accessTokenBeforeRefresh = null;
            if (LOGGER.isTraceEnabled() && this.credentials.getAccessToken() != null) {
                accessTokenBeforeRefresh = this.credentials.getAccessToken().getTokenValue();
            }
            this.credentials.refreshIfExpired();
            String accessToken = this.credentials.getAccessToken().getTokenValue();
            if (LOGGER.isTraceEnabled() && !Objects.equals(accessTokenBeforeRefresh, accessToken)) {
                LOGGER.trace("Access token was refreshed.");
            }
            LOGGER.traceExit(entryMessage, (Object)XXHashUtils.xxhash64((String)accessToken));
            return accessToken;
        }
    }
}

