/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.finding;

import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

public abstract class MetricThresholdFindingAnalysisBase
extends ThresholdFindingAnalysisBase {
    @Override
    protected void analyzeModel(SimulinkModel model) {
        double count = this.getMetric().calculateMetricValue(model);
        if (count > (double)this.getThresholds().getRedThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of " + this.getMetricIdentifier() + " threshold : " + (int)count, ETrafficLightColor.RED, count);
        } else if (count > (double)this.getThresholds().getYellowThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of " + this.getMetricIdentifier() + " threshold : " + (int)count, ETrafficLightColor.YELLOW, count);
        }
    }

    protected abstract SimulinkMetricAnalysisBase getMetric();

    protected abstract String getMetricIdentifier();
}

