/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.finding;

import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysis;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import eu.cqse.check.framework.core.EFindingEnablement;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;

@SimulinkFindingAnalysis(name="Too many Stateflow charts", description="Marks blocks with many Stateflow charts.", group="Stateflow Charts", qualityIndicator="Structure", enablement=EFindingEnablement.AUTO)
public class StateflowChartCountFinding
extends ThresholdFindingAnalysisBase {
    private static final String MESSAGE = "Violation of Stateflow chart threshold ";

    @Override
    protected void analyzeModel(SimulinkModel model) {
        NumericThresholds thresholds;
        double stateflowChartCount = 0.0;
        StateflowMachine machine = model.getStateflowMachine();
        if (machine != null) {
            stateflowChartCount = machine.getCharts().size();
        }
        if (stateflowChartCount > (double)(thresholds = this.getThresholds()).getRedThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of Stateflow chart threshold : " + (int)stateflowChartCount, ETrafficLightColor.RED, stateflowChartCount);
        } else if (stateflowChartCount > (double)thresholds.getYellowThreshold()) {
            this.createAndReportFindingForBlock((SimulinkBlock)model, "Violation of Stateflow chart threshold : " + (int)stateflowChartCount, ETrafficLightColor.YELLOW, stateflowChartCount);
        }
    }
}

