/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="merged-test-info", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={byte[].class})
public class MergedTestInfoIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    public static final String INDEX_NAME = "merged-test-info";

    public MergedTestInfoIndex(IStore store) {
        super(store);
    }

    public void setTestOriginsForCommit(CommitDescriptor targetCommit, Map<String, CommitDescriptor> methodKeyToTestOrigin) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        this.store.put(MergedTestInfoIndex.makeKey(targetCommit, abbreviator), this.serialize(methodKeyToTestOrigin, abbreviator));
    }

    private static byte[] makeKey(CommitDescriptor targetCommit, StorageStringAbbreviator abbreviator) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(targetCommit.getBranchName())), ByteArrayUtils.longToByteArray((long)targetCommit.getTimestamp())});
    }

    public @Nullable CommitDescriptor getTestOriginForCommit(CommitDescriptor key, String methodKey) throws StorageException {
        return this.getMethodKeyToTestOriginCommitMapping(key).get(methodKey);
    }

    public @NonNull Map<String, CommitDescriptor> getMethodKeyToTestOriginCommitMapping(CommitDescriptor commitDescriptor) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return this.deserialize(this.store.get(MergedTestInfoIndex.makeKey(commitDescriptor, abbreviator)), abbreviator);
    }

    private byte[] serialize(Map<String, CommitDescriptor> methodKeyToTestOrigin, StorageStringAbbreviator abbreviator) throws StorageException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (String methodKey : methodKeyToTestOrigin.keySet()) {
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(methodKey)));
            CommitDescriptor testOriginCommit = methodKeyToTestOrigin.get(methodKey);
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(testOriginCommit.getBranchName())));
            outputStream.writeBytes(ByteArrayUtils.longToByteArray((long)testOriginCommit.getTimestamp()));
        }
        return outputStream.toByteArray();
    }

    private Map<String, CommitDescriptor> deserialize(byte[] data, StorageStringAbbreviator abbreviator) throws StorageException {
        HashMap<String, CommitDescriptor> result = new HashMap<String, CommitDescriptor>();
        if (data == null) {
            return result;
        }
        for (int offset = 0; data.length > offset; offset += 16) {
            String methodKey = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset));
            String branchName = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4)));
            long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])data, (int)(offset + 8));
            result.put(methodKey, new CommitDescriptor(branchName, timestamp));
        }
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        List keysToDelete = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<String, Long> branchAndTimestamp : timestampByBranch.entrySet()) {
            String branch = branchAndTimestamp.getKey();
            long timestamp = branchAndTimestamp.getValue();
            this.store.scan(ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(branch)), (key, b) -> {
                CommitDescriptor keyCommit = new CommitDescriptor(branch, ByteArrayUtils.getLongFromByteArray((byte[])key, (int)4));
                if (keyCommit.getTimestamp() > timestamp) {
                    keysToDelete.add(key);
                }
            });
        }
        this.store.remove(keysToDelete);
    }
}

