/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.user.User;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestQueryDataRetriever;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.TgaRequestBase;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.tests.TestHistoryIndex;
import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class TgaTestQueryRequest
extends TgaRequestBase {
    private final MethodIdIndex methodIdIndex;
    private final CoverageUnitToMethodsMapIndex testsToMethodsMapIndex;
    private final boolean showOnlyExecutedMethods;
    private final Set<UniformPath> testUniformPaths;

    private TgaTestQueryRequest(Set<UniformPath> testUniformPaths, long baseline, CommitDescriptor endCommit, MethodIdIndex methodIdIndex, CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, boolean showOnlyExecutedMethods, CoverageSourceParameterBase coverageSourceOptions, ETgaAssessmentType assessmentType, IProjectId projectId, IndexLayer indexLayer) throws BadRequestException {
        super(coverageSourceOptions, assessmentType, baseline, endCommit, projectId, indexLayer);
        this.testUniformPaths = testUniformPaths;
        if (baseline != 1L) {
            throw new BadRequestException("Must not use timespan to retrieve execution treemap of a test query. Baseline timestamp (value in request " + baseline + ") must always be set to 1.");
        }
        this.methodIdIndex = methodIdIndex;
        this.testsToMethodsMapIndex = testsToMethodsMapIndex;
        this.showOnlyExecutedMethods = showOnlyExecutedMethods;
    }

    @Override
    protected ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes tgaDataRetrieverIndexes, CrossAnnotator crossAnnotator, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        return new TestQueryDataRetriever(tgaDataRetrieverIndexes.getMethodInfoIndex(), crossAnnotator, this.getPartitions(), this.methodIdIndex, this.testsToMethodsMapIndex, tgaDataRetrieverIndexes.getExtendedResourceTypeIndex(), this.showOnlyExecutedMethods, this.testUniformPaths, tgaDataRetrieverIndexes.getCodeScopesMappingIndex(), tgaEnablementPerCodeScope);
    }

    public static TgaTestQueryRequest createRequest(CoverageSourceParameterBase coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId, User user) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        CommitDescriptor endCommit = timeIntervalParameters.resolveEndCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)endCommit);
        String testQuery = tgaRequestParameters.getTestQuery();
        Set<UniformPath> testUniformPaths = TgaTestQueryRequest.getTestUniformPaths(endCommit, historyAccessOption, testQuery, projectStorageSystem, globalStorageSystem, user);
        return new TgaTestQueryRequest(testUniformPaths, timeIntervalParameters.resolveBaselineCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem)).getTimestamp(), endCommit, (MethodIdIndex)projectStorageSystem.openProjectIndex(MethodIdIndex.class, historyAccessOption), (CoverageUnitToMethodsMapIndex)projectStorageSystem.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption), tgaRequestParameters.isShowExecutedMethodsOnly(), coverageParameters, assessmentType, projectId, indexLayer);
    }

    public static TgaTestQueryRequest createSingleTestRequest(CoverageSourceParameterBase coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        CommitDescriptor endCommit = timeIntervalParameters.resolveEndCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)endCommit);
        Set<UniformPath> testUniformPaths = Set.of(tgaRequestParameters.getTestUniformPath());
        return new TgaTestQueryRequest(testUniformPaths, timeIntervalParameters.resolveBaselineCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem)).getTimestamp(), endCommit, (MethodIdIndex)projectStorageSystem.openProjectIndex(MethodIdIndex.class, historyAccessOption), (CoverageUnitToMethodsMapIndex)projectStorageSystem.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption), tgaRequestParameters.isShowExecutedMethodsOnly(), coverageParameters, assessmentType, projectId, indexLayer);
    }

    private static Set<UniformPath> getTestUniformPaths(CommitDescriptor endCommit, HistoryAccessOption historyAccessOption, String testQuery, CommitResolvingStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User user) throws StorageException {
        TestHistoryIndex testHistoryIndex = (TestHistoryIndex)projectStorageSystem.openProjectIndex(TestHistoryIndex.class, historyAccessOption);
        try {
            List<String> uniformPaths = QueryableEntityUtils.performQueryWithEmptyHandling(testQuery, testHistoryIndex, QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)projectStorageSystem, globalStorageSystem, user, StoredQueryIndex.EStoredQueryType.TEST, endCommit));
            return UniformPathCompatibilityUtil.convertSet(uniformPaths);
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new StorageException(e);
        }
    }

    @Override
    protected String getTgaRequestPrefix() {
        return "Test gap data for the tests " + String.valueOf(this.testUniformPaths);
    }
}

