/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MethodBasedTreeMapSerializationUtils {
    public static StringBuilder appendKey(StringBuilder stringBuilder, String key) {
        return stringBuilder.append("\"").append(key).append("\":");
    }

    public static StringBuilder append(StringBuilder stringBuilder, String key, TgaMethodTreeMapNode rootNode) {
        MethodBasedTreeMapSerializationUtils.appendKey(stringBuilder, key);
        return MethodBasedTreeMapSerializationUtils.appendTreeMapNode(rootNode, stringBuilder).append(",");
    }

    public static StringBuilder append(StringBuilder jsonStringBuilder, String key, String value) {
        return MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key).append(JsonUtils.serializeToJSON((Object)value)).append(",");
    }

    public static StringBuilder append(StringBuilder jsonStringBuilder, String key, CommitDescriptor commit) {
        return MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key).append(commit.toJson()).append(",");
    }

    public static StringBuilder append(StringBuilder jsonStringBuilder, String key, double value) {
        return MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key).append(value).append(',');
    }

    public static StringBuilder append(StringBuilder jsonStringBuilder, String key, long value) {
        return MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key).append(value).append(',');
    }

    public static StringBuilder append(StringBuilder jsonStringBuilder, String key, Collection<String> value) {
        return MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key).append(JsonUtils.serializeToJSON(value)).append(',');
    }

    private static StringBuilder appendTreeMapNode(TgaMethodTreeMapNode node, StringBuilder stringBuilder) {
        long count;
        stringBuilder.append("{");
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "uniformPath", node.getUniformPath());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "methodName", node.getMethodName());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "state", node.getState().name());
        if (node.getLastChangedInIssueId() != null) {
            MethodBasedTreeMapSerializationUtils.appendIssueId(stringBuilder, "lastChangedInIssueId", node.getLastChangedInIssueId());
        }
        if (node.getLastChangedTimestamp() != null) {
            MethodBasedTreeMapSerializationUtils.append(stringBuilder, "lastChangedTimestamp", node.getLastChangedTimestamp());
        }
        if (node.getLastTestTimestamp() != null) {
            MethodBasedTreeMapSerializationUtils.append(stringBuilder, "lastTestTimestamp", node.getLastTestTimestamp());
        }
        if ((count = node.getCount()) != -1L) {
            MethodBasedTreeMapSerializationUtils.append(stringBuilder, "count", count);
        }
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "start", node.getRegion().getStart());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "end", node.getRegion().getEnd());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "x", node.getX());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "y", node.getY());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "width", node.getWidth());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "height", node.getHeight());
        MethodBasedTreeMapSerializationUtils.append(stringBuilder, "area", node.getArea());
        if (!CollectionUtils.isNullOrEmpty(node.getChildren())) {
            MethodBasedTreeMapSerializationUtils.serializeChildren(node, stringBuilder);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.append("}");
    }

    private static void appendIssueId(StringBuilder jsonStringBuilder, String key, TeamscaleIssueId issueId) {
        MethodBasedTreeMapSerializationUtils.appendKey(jsonStringBuilder, key);
        jsonStringBuilder.append("{");
        MethodBasedTreeMapSerializationUtils.append(jsonStringBuilder, "internalId", issueId.getInternalId());
        MethodBasedTreeMapSerializationUtils.append(jsonStringBuilder, "externalId", issueId.getExternalId());
        MethodBasedTreeMapSerializationUtils.append(jsonStringBuilder, "connectorId", issueId.getConnectorId());
        jsonStringBuilder.deleteCharAt(jsonStringBuilder.length() - 1);
        jsonStringBuilder.append("},");
    }

    private static void serializeChildren(TgaMethodTreeMapNode rootNode, StringBuilder result) {
        List children = rootNode.getChildren();
        MethodBasedTreeMapSerializationUtils.appendKey(result, "children").append("[");
        for (ITreeMapNode voidITreeMapNode : children) {
            TgaMethodTreeMapNode child = (TgaMethodTreeMapNode)voidITreeMapNode;
            MethodBasedTreeMapSerializationUtils.appendTreeMapNode(child, result).append(",");
        }
        result.deleteCharAt(result.length() - 1);
        result.append("],");
    }

    private MethodBasedTreeMapSerializationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

