/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinks;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.TestHistoryIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestHistorySynchronizer
extends ChangeProcessorAnalysisStep {
    private static final int SYNCHRONIZER_BATCH_SIZE_DEFAULT = 1000;
    private static final Logger LOGGER = LogManager.getLogger();
    static final Marker TS33927_LOG_MARKER = MarkerManager.getMarker((String)"TS-33927");
    @DeltaSource(value=TestLinksIndex.class)
    private KeyDelta keyDeltaTestLinks;
    @DeltaSource(value=TestExecutionIndex.class)
    private TestExecutionIndexDelta keyDeltaTestExecutions;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestLinksIndex testLinksIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestImplementationIndex testImplementationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestExecutionIndex testExecutionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TestHistoryIndex testExecutionHistoryIndex;

    public void execute() throws StorageException, ExecutionException {
        LOGGER.trace(TS33927_LOG_MARKER, () -> "Test execution added/changed keys: " + String.valueOf(this.keyDeltaTestExecutions.getAddedOrChangedPartitionsAndPaths()));
        LOGGER.trace(TS33927_LOG_MARKER, () -> "Test execution deleted keys: " + String.valueOf(this.keyDeltaTestExecutions.getDeletedPartitionsAndPaths()));
        LOGGER.trace(TS33927_LOG_MARKER, () -> "Test links added/changed keys: " + String.valueOf(this.keyDeltaTestLinks.getAddedOrChangedKeysAsStrings()));
        LOGGER.trace(TS33927_LOG_MARKER, () -> "Test links deleted keys: " + String.valueOf(this.keyDeltaTestLinks.getDeletedKeysAsStrings()));
        List addedOrChangedTestLinks = this.keyDeltaTestLinks.getAddedOrChangedKeysAsStrings();
        Set addedOrChangedTestExecutions = CollectionUtils.mapToSet(this.keyDeltaTestExecutions.getAddedOrChangedPartitionsAndPaths(), PartitionAndPath::getUniformPath);
        ArrayList testLinksToRetrieve = new ArrayList(CollectionUtils.unionSet((Collection)addedOrChangedTestLinks, (Collection[])new Collection[]{addedOrChangedTestExecutions}));
        this.executeInParallelBatches(testLinksToRetrieve, this::processTestLinks, Integer.getInteger("com.teamscale.test-history-synchronizer.batch-size", 1000));
        this.testExecutionHistoryIndex.removeIds(this.getSchedulingCommit().getTimestamp(), this.keyDeltaTestLinks.getDeletedKeysAsStrings());
    }

    private void processTestLinks(List<String> testLinksToRetrieve) throws StorageException {
        List<TestLinks> testLinksList = this.testLinksIndex.getTestLinks(testLinksToRetrieve, true);
        LOGGER.trace(TS33927_LOG_MARKER, () -> "Test links list: " + String.valueOf(testLinksList));
        Map<String, TestImplementation> testImplementationMap = this.loadTestImplementations(testLinksList);
        Map<String, List<TestExecutionWithPartition>> testExecutionPathToResults = this.loadTestExecutions(testLinksToRetrieve, testLinksList);
        ArrayList testsEntries = new ArrayList();
        CollectionUtils.forEach(testLinksToRetrieve, testLinksList, (changedTestPath, testLinks) -> {
            List<TestExecutionWithPartition> executions = testExecutionPathToResults.getOrDefault(changedTestPath, List.of());
            TestHistoryEntry testHistoryEntry = TestHistorySynchronizer.buildTestHistoryEntry(testImplementationMap, changedTestPath, testLinks, executions);
            testsEntries.add(testHistoryEntry);
        });
        this.testExecutionHistoryIndex.store(this.getSchedulingCommit().getTimestamp(), testsEntries);
    }

    private static @NonNull TestHistoryEntry buildTestHistoryEntry(Map<String, TestImplementation> testImplementationMap, String changedTestPath, TestLinks testLinks, List<TestExecutionWithPartition> executions) {
        String testName;
        String codeLocation = null;
        if (testLinks.getTestImplementation() != null) {
            TestImplementation testImplementation = testImplementationMap.get(testLinks.getTestImplementation());
            codeLocation = testImplementation.getLocation().getUniformPath();
            testName = changedTestPath.startsWith(UniformPath.EType.TEST_IMPLEMENTATION.getPrefix()) ? testImplementation.getName() : TestUniformPathUtils.convertCoverageUnitPathToTestName((String)changedTestPath);
        } else {
            testName = TestUniformPathUtils.convertCoverageUnitPathToTestName((String)changedTestPath);
        }
        return new TestHistoryEntry(changedTestPath, testName, codeLocation, executions);
    }

    private @NonNull Map<String, TestImplementation> loadTestImplementations(List<TestLinks> testLinksList) throws StorageException {
        List<String> uniformPaths = testLinksList.stream().map(TestLinks::getTestImplementation).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<TestImplementation> testImplementations = this.testImplementationIndex.getTestImplementations(uniformPaths);
        return CollectionUtils.zipAsMap(uniformPaths, testImplementations);
    }

    private Map<String, List<TestExecutionWithPartition>> loadTestExecutions(List<String> addedOrChangedTestLinks, List<TestLinks> testLinksList) throws StorageException {
        ArrayList<PartitionAndPath> relevantTestExecutionPartitionAndPaths = new ArrayList<PartitionAndPath>();
        CollectionUtils.forEach(addedOrChangedTestLinks, testLinksList, (testLinkPath, testLinks) -> {
            for (String partition : testLinks.getPartitions()) {
                relevantTestExecutionPartitionAndPaths.add(new PartitionAndPath(partition, testLinkPath));
            }
        });
        List<TestExecutionWithPartition> testExecutionsForUniformPathsAndPartitions = this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(relevantTestExecutionPartitionAndPaths);
        int i = 0;
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        for (TestExecutionWithPartition execution : testExecutionsForUniformPathsAndPartitions) {
            if (execution == null) {
                LOGGER.error("Did not find a test execution for path and partition \"" + String.valueOf(relevantTestExecutionPartitionAndPaths.get(i)) + "\". This should not happen and means that the TestLinksIndex and the TestExecutionIndex are out of sync. We're ignoring the missing test execution here to prevent the TestHistorySynchronizer from crashing. Please enable trace logging for the Log4j marker \"" + String.valueOf(TS33927_LOG_MARKER) + "\" as described in https://logging.apache.org/log4j/2.x/manual/filters.html (Section MarkerFilter) and report this as a bug, including the trace logs.");
                indexesToRemove.add(i);
            }
            ++i;
        }
        indexesToRemove.forEach(index -> testExecutionsForUniformPathsAndPartitions.remove((int)index));
        return testExecutionsForUniformPathsAndPartitions.stream().collect(Collectors.groupingBy(t -> t.getTestExecution().getUniformPath()));
    }
}

