/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.algorithm.ApproximateMatchingStrategy;
import com.teamscale.index.tracking.algorithm.CrossFileExactMatchingStrategy;
import com.teamscale.index.tracking.algorithm.DiffBasedMatchingStrategy;
import com.teamscale.index.tracking.algorithm.ExternalFindingsMatchingStrategy;
import com.teamscale.index.tracking.algorithm.FindingsTrackingResult;
import com.teamscale.index.tracking.algorithm.SameFileExactMatchingStrategy;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedFindingContextMatchingStrategyBase;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import com.teamscale.index.tracking.algorithm.TrackedUnitUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.BidirectionalMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class FindingsTrackingAlgorithm {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String EXTERNAL_ID_PROPERTY = "external-id";
    private final TokenElementIndex changedContentIndex;
    private final Map<String, String> trackingGroupNameByPartition;
    private final List<TokenElementIndex> baselineContentIndexesByBranch;
    private final CommitDescriptor commit;
    private final ElementHistoryIndex historyIndex;
    private final int numberOfBranches;
    private final List<TrackedFindingContextMatchingStrategyBase> matchingStrategies = new ArrayList<TrackedFindingContextMatchingStrategyBase>();
    private final IProfilingMonitor profilingMonitor;

    public static FindingsTrackingAlgorithm createTrackingAlgorithm(CommitDescriptor commit, Map<String, String> trackingGroupNameByPartition, TokenElementIndex changedContentIndex, List<TokenElementIndex> baselineContentIndexes, ElementHistoryIndex historyIndex, IProfilingMonitor profilingMonitor, PublicProjectId projectId) {
        return new FindingsTrackingAlgorithm(commit, trackingGroupNameByPartition, changedContentIndex, baselineContentIndexes, historyIndex, profilingMonitor, FindingsTrackingAlgorithm.getMatchingStrategies(projectId));
    }

    private static List<ITrackingStrategyFactory> getMatchingStrategies(PublicProjectId projectId) {
        ArrayList<ITrackingStrategyFactory> factories = new ArrayList<ITrackingStrategyFactory>(List.of(DiffBasedMatchingStrategy::new, SameFileExactMatchingStrategy::new, CrossFileExactMatchingStrategy::new, ExternalFindingsMatchingStrategy::new));
        if (TeamscaleSystemProperties.DISABLED_FINDINGS_TRACKING_APPROXIMATE_MATCHING_STRATEGY.getValue().map(pattern -> pattern.matcher(projectId.projectId)).filter(Matcher::matches).isEmpty()) {
            factories.add(ApproximateMatchingStrategy::new);
        }
        return factories;
    }

    private FindingsTrackingAlgorithm(CommitDescriptor commit, Map<String, String> trackingGroupNameByPartition, TokenElementIndex changedContentIndex, List<TokenElementIndex> baselineContentIndexesByBranch, ElementHistoryIndex historyIndex, IProfilingMonitor profilingMonitor, List<ITrackingStrategyFactory> trackingStrategyFactories) {
        this.commit = commit;
        this.trackingGroupNameByPartition = trackingGroupNameByPartition;
        this.changedContentIndex = changedContentIndex;
        this.baselineContentIndexesByBranch = baselineContentIndexesByBranch;
        this.numberOfBranches = baselineContentIndexesByBranch.size();
        this.historyIndex = historyIndex;
        this.profilingMonitor = profilingMonitor;
        for (ITrackingStrategyFactory trackingStrategyFactory : trackingStrategyFactories) {
            this.matchingStrategies.add(trackingStrategyFactory.create());
        }
    }

    private ListMap<String, TrackedFindingWithContext> clusterFindings(Collection<TrackedFindingWithContext> findings) {
        ListMap result = new ListMap();
        for (TrackedFindingWithContext finding : findings) {
            result.add((Object)this.getClusterKey(finding.getFinding()), (Object)finding);
        }
        return result;
    }

    private PairList<TrackedFindingWithContext, TrackedFindingWithContext> performClusteredTracking(List<TrackedFindingWithContext> baselineCluster, List<TrackedFindingWithContext> changedCluster, Map<String, TrackedElement> changedElements) {
        PairList trackingResult = new PairList();
        ArrayList<TrackedFindingWithContext> baselineElementLocationFindings = new ArrayList<TrackedFindingWithContext>();
        ArrayList<TrackedFindingWithContext> baselineTextRegionLocationFindings = new ArrayList<TrackedFindingWithContext>();
        ArrayList<TrackedFindingWithContext> baselineQualifiedNameLocationFindings = new ArrayList<TrackedFindingWithContext>();
        FindingsTrackingAlgorithm.splitFindings(baselineCluster, baselineElementLocationFindings, baselineTextRegionLocationFindings, baselineQualifiedNameLocationFindings);
        ArrayList<TrackedFindingWithContext> changedElementLocationFindings = new ArrayList<TrackedFindingWithContext>();
        ArrayList<TrackedFindingWithContext> changedTextRegionLocationFindings = new ArrayList<TrackedFindingWithContext>();
        ArrayList<TrackedFindingWithContext> changedQualifiedNameLocationFindings = new ArrayList<TrackedFindingWithContext>();
        FindingsTrackingAlgorithm.splitFindings(changedCluster, changedElementLocationFindings, changedTextRegionLocationFindings, changedQualifiedNameLocationFindings);
        if (!baselineElementLocationFindings.isEmpty() && !changedElementLocationFindings.isEmpty()) {
            trackingResult.addAll(this.performClusteredTrackingForElementLocation(baselineElementLocationFindings, changedElementLocationFindings, changedElements));
        }
        if (!baselineQualifiedNameLocationFindings.isEmpty() && !changedQualifiedNameLocationFindings.isEmpty()) {
            trackingResult.addAll(FindingsTrackingAlgorithm.performClusteredTrackingForQualifiedNameLocation(baselineQualifiedNameLocationFindings, changedQualifiedNameLocationFindings));
        }
        if (!baselineTextRegionLocationFindings.isEmpty() && !changedTextRegionLocationFindings.isEmpty()) {
            trackingResult.addAll(this.performClusteredTrackingForTextRegionLocation(baselineTextRegionLocationFindings, changedTextRegionLocationFindings));
        }
        return trackingResult;
    }

    private static void splitFindings(List<TrackedFindingWithContext> findings, List<TrackedFindingWithContext> elementLocationFindings, List<TrackedFindingWithContext> textRegionLocationFindings, List<TrackedFindingWithContext> qualifiedNameLocationFindings) {
        for (TrackedFindingWithContext findingWithContext : findings) {
            ElementLocation location = findingWithContext.getFinding().getLocation();
            if (location instanceof QualifiedNameLocation) {
                qualifiedNameLocationFindings.add(findingWithContext);
                continue;
            }
            if (location instanceof TextRegionLocation) {
                textRegionLocationFindings.add(findingWithContext);
                continue;
            }
            elementLocationFindings.add(findingWithContext);
        }
    }

    private String getClusterKey(TrackedFinding finding) {
        String partition = finding.getFindingIndexPartition();
        String clusterKey = finding.getTypeId() + ":" + this.trackingGroupNameByPartition.getOrDefault(partition, partition);
        Object externalId = finding.getProperties().get(EXTERNAL_ID_PROPERTY);
        if (externalId != null) {
            clusterKey = clusterKey + ":" + String.valueOf(externalId);
        }
        return clusterKey;
    }

    public FindingsTrackingResult performTracking(List<Collection<TrackedFinding>> baselineFindingsForAllBranches, Collection<TrackedFinding> changedFindings, IParallelTaskExecutor executor) throws StorageException, ExecutionException, InterruptedException {
        HashMap<String, TrackedElement> changedElements = new HashMap<String, TrackedElement>(this.loadElements(changedFindings, executor));
        if (changedFindings.isEmpty() || baselineFindingsForAllBranches.isEmpty()) {
            return new FindingsTrackingResult((PairList<TrackedFindingWithContext, TrackedFindingWithContext>)new PairList(), changedElements);
        }
        List<Map<String, TrackedElement>> baselineElementsByBranch = this.loadOldElementsForAllBranches(baselineFindingsForAllBranches, executor);
        Set<TrackedFindingWithContext> changedFindingsWithContext = FindingsTrackingAlgorithm.augmentWithContext(new ArrayList<TrackedFinding>(changedFindings), changedElements, 0);
        Set<TrackedFindingWithContext> allBaselineFindingsWithContext = this.addContextToFindingsForBranches(baselineFindingsForAllBranches, baselineElementsByBranch);
        this.setPeerElements(changedFindingsWithContext, allBaselineFindingsWithContext, baselineElementsByBranch, changedElements);
        ListMap<String, TrackedFindingWithContext> clusteredBaselinedFindings = this.clusterFindings(allBaselineFindingsWithContext);
        ListMap<String, TrackedFindingWithContext> clusteredChangedFindings = this.clusterFindings(changedFindingsWithContext);
        ArrayList<Callable<PairList>> runnables = new ArrayList<Callable<PairList>>();
        for (String key : clusteredBaselinedFindings.getKeys()) {
            List baselineCluster = (List)clusteredBaselinedFindings.getCollection((Object)key);
            List changedCluster = (List)clusteredChangedFindings.getCollection((Object)key);
            if (changedCluster == null || changedCluster.isEmpty()) continue;
            runnables.add(() -> this.performClusteredTracking(baselineCluster, changedCluster, changedElements));
        }
        PairList trackingResult = (PairList)executor.executeInParallelAndCombine(runnables, PairList.combine());
        return new FindingsTrackingResult((PairList<TrackedFindingWithContext, TrackedFindingWithContext>)trackingResult, changedElements);
    }

    public Map<String, TrackedElement> loadElements(Collection<TrackedFinding> findings, IParallelTaskExecutor parallelTaskExecutor) throws ExecutionException, InterruptedException {
        return FindingsTrackingAlgorithm.loadElements(findings, this.changedContentIndex, parallelTaskExecutor);
    }

    private void setPeerElements(Set<TrackedFindingWithContext> changedFindingsWithContext, Set<TrackedFindingWithContext> allBaselineFindingsWithContext, List<Map<String, TrackedElement>> baselineElementsByBranch, Map<String, TrackedElement> changedElements) throws StorageException {
        int branchIndex = 0;
        while (branchIndex < this.numberOfBranches) {
            BidirectionalMap<TrackedElement, TrackedElement> changedToBaselineElements = this.mapChangedElementsToBaselineElements(baselineElementsByBranch.get(branchIndex), changedElements);
            int finalBranchIndex = branchIndex++;
            changedFindingsWithContext.forEach(finding -> finding.setPeerElementForBranch((TrackedElement)changedToBaselineElements.getSecond((Object)finding.getElement()), finalBranchIndex));
            allBaselineFindingsWithContext.forEach(finding -> finding.setPeerElementForBranch((TrackedElement)changedToBaselineElements.getFirst((Object)finding.getElement()), 0));
        }
    }

    private Set<TrackedFindingWithContext> addContextToFindingsForBranches(List<Collection<TrackedFinding>> baselineFindingsForBranches, List<Map<String, TrackedElement>> baselineElementsForBranches) {
        HashSet<TrackedFindingWithContext> allFindingsWithContext = new HashSet<TrackedFindingWithContext>();
        for (int branchIndex = 0; branchIndex < this.numberOfBranches; ++branchIndex) {
            ArrayList<TrackedFinding> baselineFindingsForBranch = new ArrayList<TrackedFinding>(baselineFindingsForBranches.get(branchIndex));
            Map<String, TrackedElement> baselineElementsForBranch = baselineElementsForBranches.get(branchIndex);
            Set<TrackedFindingWithContext> baselineFindingContext = FindingsTrackingAlgorithm.augmentWithContext(baselineFindingsForBranch, baselineElementsForBranch, branchIndex);
            allFindingsWithContext.addAll(baselineFindingContext);
        }
        return allFindingsWithContext;
    }

    private static Set<TrackedFindingWithContext> augmentWithContext(List<TrackedFinding> findings, Map<String, TrackedElement> elementsMap, int branchIndex) {
        IdentityHashSet result = new IdentityHashSet();
        for (TrackedFinding finding : findings) {
            TrackedElement element = elementsMap.get(finding.getLocation().getUniformPath());
            if (element == null || finding.getLocation() instanceof TextRegionLocation && element.getUnits().isEmpty()) continue;
            result.add(new TrackedFindingWithContext(finding, element, branchIndex));
        }
        return result;
    }

    private List<Map<String, TrackedElement>> loadOldElementsForAllBranches(List<Collection<TrackedFinding>> findingsForAllBranches, IParallelTaskExecutor parallelTaskExecutor) throws ExecutionException, InterruptedException {
        ArrayList<Map<String, TrackedElement>> elementsForAllBranches = new ArrayList<Map<String, TrackedElement>>();
        for (int branchIndex = 0; branchIndex < this.numberOfBranches; ++branchIndex) {
            elementsForAllBranches.add(FindingsTrackingAlgorithm.loadElements(findingsForAllBranches.get(branchIndex), this.baselineContentIndexesByBranch.get(branchIndex), parallelTaskExecutor));
        }
        return elementsForAllBranches;
    }

    private static Map<String, TrackedElement> loadElements(Collection<TrackedFinding> findings, TokenElementIndex contentIndex, IParallelTaskExecutor parallelTaskExecutor) throws ExecutionException, InterruptedException {
        ConcurrentHashMap<String, TrackedElement> trackedElementsByUniformPath = new ConcurrentHashMap<String, TrackedElement>();
        List allUniformPaths = findings.stream().map(finding -> finding.getLocation().getUniformPath()).distinct().collect(Collectors.toList());
        if (!allUniformPaths.isEmpty()) {
            parallelTaskExecutor.processInParallelBatches(allUniformPaths, batch -> FindingsTrackingAlgorithm.loadElementBatch(findings, contentIndex, trackedElementsByUniformPath, batch));
        }
        return trackedElementsByUniformPath;
    }

    private static void loadElementBatch(Collection<TrackedFinding> findings, TokenElementIndex contentIndex, Map<String, TrackedElement> trackedElementsByUniformPath, List<String> uniformPaths) throws StorageException {
        List<TokenElementInfo> elementInfos = contentIndex.getTokenElements(uniformPaths);
        for (int i = 0; i < elementInfos.size(); ++i) {
            TokenElementInfo elementInfo = elementInfos.get(i);
            if (elementInfo == null) {
                LOGGER.error("No old content found for " + uniformPaths.get(i) + " but still had findings in partition " + FindingsTrackingAlgorithm.determinePartition(findings, uniformPaths.get(i)) + "! Most likely this is a block configuration error (missing delete).");
                continue;
            }
            String uniformPath = elementInfo.getUniformPath();
            trackedElementsByUniformPath.put(uniformPath, new TrackedElement(uniformPath, TrackedUnitUtils.splitElementIntoUnits(elementInfo)));
        }
    }

    private static String determinePartition(Collection<TrackedFinding> findings, String uniformPath) {
        for (TrackedFinding finding : findings) {
            if (!uniformPath.equals(finding.getLocation().getUniformPath())) continue;
            return finding.getFindingIndexPartition();
        }
        return "unknown";
    }

    private BidirectionalMap<TrackedElement, TrackedElement> mapChangedElementsToBaselineElements(Map<String, TrackedElement> baselineElements, Map<String, TrackedElement> changedElements) throws StorageException {
        List<String> changedUniformPaths = changedElements.keySet().stream().sorted().toList();
        BidirectionalMap changedElementsToBaselineElements = new BidirectionalMap();
        List<ElementHistoryEntry> historyEntries = this.historyIndex.getHistoryEntries(changedUniformPaths, false);
        for (int i = 0; i < changedUniformPaths.size(); ++i) {
            String uniformPath = changedUniformPaths.get(i);
            ElementHistoryEntry historyEntry = historyEntries.get(i);
            if (historyEntry == null) {
                LOGGER.error("No history entry found for {}", (Object)uniformPath);
                continue;
            }
            EElementHistoryChangeType changeType = historyEntry.getChangeType();
            String baselineUniformPath = this.getUniformPathOfBaseline(historyEntry, changeType, uniformPath);
            TrackedElement baselineElement = baselineElements.get(baselineUniformPath);
            if (baselineElement == null && (baselineElement = baselineElements.get(uniformPath)) == null || changedElementsToBaselineElements.getFirst((Object)baselineElement) != null && changeType != EElementHistoryChangeType.EDIT) continue;
            changedElementsToBaselineElements.put((Object)changedElements.get(uniformPath), (Object)baselineElement);
        }
        return changedElementsToBaselineElements;
    }

    private String getUniformPathOfBaseline(ElementHistoryEntry historyEntry, EElementHistoryChangeType changeType, String uniformPath) {
        if (historyEntry.getTimestamp() == this.commit.getTimestamp()) {
            return switch (changeType) {
                default -> throw new MatchException(null, null);
                case EElementHistoryChangeType.ADD -> uniformPath;
                case EElementHistoryChangeType.EDIT, EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD -> uniformPath;
                case EElementHistoryChangeType.MOVE, EElementHistoryChangeType.COPY -> historyEntry.getOriginPath();
                case EElementHistoryChangeType.DELETE -> (String)CCSMAssert.fail((String)"Delete encountered!");
            };
        }
        return uniformPath;
    }

    private PairList<TrackedFindingWithContext, TrackedFindingWithContext> performClusteredTrackingForElementLocation(List<TrackedFindingWithContext> baselineCluster, List<TrackedFindingWithContext> changedCluster, Map<String, TrackedElement> changedElements) {
        PairList trackingResult = new PairList();
        HashMap<String, TrackedFindingWithContext> findingForElementLocation = new HashMap<String, TrackedFindingWithContext>();
        for (TrackedFindingWithContext baselineFinding : baselineCluster) {
            findingForElementLocation.put(FindingsTrackingAlgorithm.getElementLocationMappingKey(baselineFinding.getFinding().getLocation().getUniformPath(), baselineFinding.getFinding()), baselineFinding);
        }
        for (TrackedFindingWithContext changedFinding : changedCluster) {
            Optional<String> baselineElementLocation;
            TrackedElement changedElement = changedElements.get(changedFinding.getFinding().getLocation().getUniformPath());
            if (changedElement == null || (baselineElementLocation = IntStream.range(0, this.numberOfBranches).mapToObj(changedFinding::getPeerElementForBranch).filter(Objects::nonNull).map(peerElement -> FindingsTrackingAlgorithm.getElementLocationMappingKey(peerElement.getUniformPath(), changedFinding.getFinding())).filter(findingForElementLocation::containsKey).findFirst()).isEmpty()) continue;
            trackingResult.add((Object)((TrackedFindingWithContext)findingForElementLocation.remove(baselineElementLocation.get())), (Object)changedFinding);
        }
        return trackingResult;
    }

    private static PairList<TrackedFindingWithContext, TrackedFindingWithContext> performClusteredTrackingForQualifiedNameLocation(List<TrackedFindingWithContext> baselineCluster, List<TrackedFindingWithContext> changedCluster) {
        PairList trackingResult = new PairList();
        HashMap<String, TrackedFindingWithContext> findingForElementLocation = new HashMap<String, TrackedFindingWithContext>();
        for (TrackedFindingWithContext baselineFinding : baselineCluster) {
            findingForElementLocation.put(FindingsTrackingAlgorithm.getQualifiedNameLocationMappingKey(baselineFinding.getFinding()), baselineFinding);
        }
        for (TrackedFindingWithContext changedFinding : changedCluster) {
            TrackedFindingWithContext baselineFinding = (TrackedFindingWithContext)findingForElementLocation.remove(FindingsTrackingAlgorithm.getQualifiedNameLocationMappingKey(changedFinding.getFinding()));
            if (baselineFinding == null) continue;
            trackingResult.add((Object)baselineFinding, (Object)changedFinding);
        }
        return trackingResult;
    }

    private static String getElementLocationMappingKey(String baselineUniformPath, TrackedFinding finding) {
        return baselineUniformPath + FindingsTrackingAlgorithm.getNormalizedMessageSuffix(finding);
    }

    private static String getNormalizedMessageSuffix(TrackedFinding finding) {
        return "::" + FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)finding);
    }

    private static String getQualifiedNameLocationMappingKey(TrackedFinding finding) {
        QualifiedNameLocation qualifiedNameLocation = (QualifiedNameLocation)CCSMAssert.checkedCast((Object)finding.getLocation(), QualifiedNameLocation.class);
        return qualifiedNameLocation.getUniformPath() + "::" + qualifiedNameLocation.getQualifiedName() + FindingsTrackingAlgorithm.getNormalizedMessageSuffix(finding);
    }

    private PairList<TrackedFindingWithContext, TrackedFindingWithContext> performClusteredTrackingForTextRegionLocation(List<TrackedFindingWithContext> baselineCluster, List<TrackedFindingWithContext> changedCluster) {
        PairList trackingResult = new PairList();
        HashSet<TrackedFindingWithContext> baselineFindingContext = new HashSet<TrackedFindingWithContext>(baselineCluster);
        HashSet<TrackedFindingWithContext> changedFindingContext = new HashSet<TrackedFindingWithContext>(changedCluster);
        for (TrackedFindingContextMatchingStrategyBase matchingStrategy : this.matchingStrategies) {
            if (baselineFindingContext.isEmpty() || changedFindingContext.isEmpty()) continue;
            this.profilingMonitor.startProfiling(matchingStrategy.getClass().getSimpleName());
            PairList<TrackedFindingWithContext, TrackedFindingWithContext> trackedFindings = matchingStrategy.performMatching((UnmodifiableSet<TrackedFindingWithContext>)CollectionUtils.asUnmodifiable(baselineFindingContext), (UnmodifiableSet<TrackedFindingWithContext>)CollectionUtils.asUnmodifiable(changedFindingContext));
            FindingsTrackingAlgorithm.removeTrackedFindings(baselineFindingContext, (List<TrackedFindingWithContext>)trackedFindings.getFirstList());
            FindingsTrackingAlgorithm.removeTrackedFindings(changedFindingContext, (List<TrackedFindingWithContext>)trackedFindings.getSecondList());
            trackingResult.addAll(trackedFindings);
            this.profilingMonitor.stopProfiling(matchingStrategy.getClass().getSimpleName());
        }
        return trackingResult;
    }

    private static void removeTrackedFindings(Set<TrackedFindingWithContext> findingContexts, List<TrackedFindingWithContext> findingsToRemove) {
        Set findingIdsToRemove = findingsToRemove.stream().map(finding -> finding.getFinding().getId()).collect(Collectors.toSet());
        findingContexts.removeIf(finding -> findingIdsToRemove.contains(finding.getFinding().getId()));
    }

    @FunctionalInterface
    private static interface ITrackingStrategyFactory {
        public TrackedFindingContextMatchingStrategyBase create();
    }
}

