/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.usage_data.CommitterDataCollector;
import com.teamscale.index.usage_data.UserCounts;

@PeriodicMaintenanceJob(cronExpression="47 * * * *")
public class NumberOfCommittersComputationTrigger
extends MaintenanceTriggerBase {
    public void execute() throws Exception {
        UserLastActivityIndex lastActivityIndex = (UserLastActivityIndex)this.indexLayer.openGlobalIndex(UserLastActivityIndex.class);
        CommitterDataCollector committerCalculator = new CommitterDataCollector(this.indexLayer);
        UserCounts userCounts = committerCalculator.calculateNumberOfCommittersForAllProjects();
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_DAY, (long)userCounts.lastDay());
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_WEEK, (long)userCounts.lastWeek());
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_MONTH, (long)userCounts.lastMonth());
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_90DAYS, (long)userCounts.lastQuarter());
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_180DAYS, (long)userCounts.last180Days());
        lastActivityIndex.setNumberOfCommitters(EUserActivityPeriods.LAST_YEAR, (long)userCounts.lastYear());
    }
}

