/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;

public class Tracking<R extends Trackable, B extends Trackable> {
    private final IdentityHashMap<R, B> rawToBase = new IdentityHashMap();
    private final IdentityHashMap<B, R> baseToRaw = new IdentityHashMap();
    private final Collection<R> raws;
    private final Collection<B> bases;

    public Tracking(Supplier<Collection<R>> rawTrackableSupplier, Supplier<Collection<B>> baseTrackableSupplier) {
        this.raws = rawTrackableSupplier.get();
        this.bases = baseTrackableSupplier.get();
    }

    public Iterable<R> getUnmatchedRaws() {
        ArrayList<Trackable> result = new ArrayList<Trackable>();
        for (Trackable r : this.raws) {
            if (this.rawToBase.containsKey(r)) continue;
            result.add(r);
        }
        return result;
    }

    public Map<R, B> getMatchedRaws() {
        return this.rawToBase;
    }

    public Iterable<B> getUnmatchedBases() {
        ArrayList<Trackable> result = new ArrayList<Trackable>();
        for (Trackable b : this.bases) {
            if (this.baseToRaw.containsKey(b)) continue;
            result.add(b);
        }
        return result;
    }

    void match(R raw, B base) {
        this.rawToBase.put(raw, base);
        this.baseToRaw.put(base, raw);
    }

    boolean isComplete() {
        return this.rawToBase.size() == this.raws.size();
    }

    @CheckForNull
    public B getMatch(R trackable) {
        return (B)((Trackable)this.rawToBase.get(trackable));
    }
}

