/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.smartnotifications;

import com.google.common.util.concurrent.MoreExecutors;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.client.smartnotification.ShowSmartNotificationParams;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.developers.DevelopersApi;
import org.sonarsource.sonarlint.core.smartnotifications.LastEventPolling;
import org.sonarsource.sonarlint.core.smartnotifications.ServerNotification;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.websocket.WebSocketService;

@Named
@Singleton
public class SmartNotifications {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final ConfigurationRepository configurationRepository;
    private final ConnectionConfigurationRepository connectionRepository;
    private final ServerApiProvider serverApiProvider;
    private final SonarLintClient client;
    private final TelemetryServiceImpl telemetryService;
    private final WebSocketService webSocketService;
    private final InitializeParams params;
    private final Map<String, Boolean> isConnectionIdSupported;
    private final LastEventPolling lastEventPollingService;
    private ScheduledExecutorService smartNotificationsPolling;

    public SmartNotifications(ConfigurationRepository configurationRepository, ConnectionConfigurationRepository connectionRepository, ServerApiProvider serverApiProvider, SonarLintClient client, StorageService storageService, TelemetryServiceImpl telemetryService, WebSocketService webSocketService, InitializeParams params) {
        this.configurationRepository = configurationRepository;
        this.connectionRepository = connectionRepository;
        this.serverApiProvider = serverApiProvider;
        this.client = client;
        this.telemetryService = telemetryService;
        this.webSocketService = webSocketService;
        this.params = params;
        this.isConnectionIdSupported = new HashMap<String, Boolean>();
        this.lastEventPollingService = new LastEventPolling(storageService);
    }

    @PostConstruct
    public void initialize() {
        if (!this.params.getFeatureFlags().shouldManageSmartNotifications()) {
            return;
        }
        this.smartNotificationsPolling = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Smart Notifications Polling"));
        this.smartNotificationsPolling.scheduleAtFixedRate(this::poll, 1L, 60L, TimeUnit.SECONDS);
    }

    private void poll() {
        Map<String, Map<String, Set<String>>> keysAndScopeIdsPerConnectionId = this.configurationRepository.getScopeIdsPerProjectKeyPerConnectionId();
        for (Map.Entry<String, Map<String, Set<String>>> keysAndScopeIds : keysAndScopeIdsPerConnectionId.entrySet()) {
            String connectionId = keysAndScopeIds.getKey();
            AbstractConnectionConfiguration connection = this.connectionRepository.getConnectionById(connectionId);
            Optional<ServerApi> httpClient = this.serverApiProvider.getServerApi(connectionId);
            if (connection == null || connection.isDisableNotifications() || !httpClient.isPresent() || this.shouldSkipPolling(connection)) continue;
            this.manageNotificationsForConnection(httpClient.get(), keysAndScopeIds.getValue(), connection);
        }
    }

    private void manageNotificationsForConnection(ServerApi serverApi, Map<String, Set<String>> scopeIdsPerProjectKey, AbstractConnectionConfiguration connection) {
        DevelopersApi developersApi = serverApi.developers();
        String connectionId = connection.getConnectionId();
        Boolean isSupported = this.isConnectionIdSupported.computeIfAbsent(connectionId, v -> developersApi.isSupported());
        if (Boolean.TRUE.equals(isSupported)) {
            Map<String, ZonedDateTime> projectKeysByLastEventPolling = scopeIdsPerProjectKey.keySet().stream().collect(Collectors.toMap(Function.identity(), p -> SmartNotifications.getLastNotificationTime(this.lastEventPollingService.getLastEventPolling(connectionId, (String)p))));
            List<ServerNotification> notifications = SmartNotifications.retrieveServerNotifications(developersApi, projectKeysByLastEventPolling);
            for (ServerNotification n : notifications) {
                ShowSmartNotificationParams smartNotification = new ShowSmartNotificationParams(n.message(), n.link(), scopeIdsPerProjectKey.get(n.projectKey()), n.category(), connectionId);
                this.client.showSmartNotification(smartNotification);
                this.telemetryService.smartNotificationsReceived(n.category());
            }
            projectKeysByLastEventPolling.keySet().forEach(projectKey -> this.lastEventPollingService.setLastEventPolling(ZonedDateTime.now(), connectionId, (String)projectKey));
        }
    }

    private boolean shouldSkipPolling(AbstractConnectionConfiguration connection) {
        return connection.getKind() == ConnectionKind.SONARCLOUD && this.webSocketService.hasOpenConnection();
    }

    @PreDestroy
    public void shutdown() {
        if (this.smartNotificationsPolling != null && !MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.smartNotificationsPolling, (long)5L, (TimeUnit)TimeUnit.SECONDS)) {
            this.logger.warn("Unable to stop smart notifications executor service in a timely manner");
        }
    }

    private static ZonedDateTime getLastNotificationTime(ZonedDateTime lastTime) {
        ZonedDateTime oneDayAgo = ZonedDateTime.now().minusDays(1L);
        return lastTime.isAfter(oneDayAgo) ? lastTime : oneDayAgo;
    }

    private static List<ServerNotification> retrieveServerNotifications(DevelopersApi developersApi, Map<String, ZonedDateTime> projectKeysByLastEventPolling) {
        return developersApi.getEvents(projectKeysByLastEventPolling).stream().map(e -> new ServerNotification(e.getCategory(), e.getMessage(), e.getLink(), e.getProjectKey(), e.getTime())).collect(Collectors.toList());
    }
}

