# Description
Keep single parameter calls on one line

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#keep-single-parameter-calls-on-one-line

# Examples
**Bad example**
```abap
call_method(
  2 ).
```

**Good example**
```abap
call_method( 2 ).
```

# Clean ABAP Code Style Guide
```ABAP
DATA(unique_list) = remove_duplicates( list ).
remove_duplicates( CHANGING list = list ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
DATA(unique_list) = remove_duplicates(
                           list ).
DATA(unique_list) = remove_duplicates(
                         CHANGING
                           list = list ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/keep_single_parameter_on_one_line) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
