
This plugin is part of a family of tests that detect the use of known bad
* <a href='checks.html#checks/?languages=PYTHON&tools=BANDIT&rule=bandit.B502'>ssl_with_bad_version</a>
a complete discussion. Specifically, this plugin test scans for Python
methods with default parameter values that specify the use of broken
SSL/TLS protocol versions. Currently, detection supports methods using
Python's native SSL/TLS support and the pyOpenSSL module. A MEDIUM severity
warning will be reported whenever known broken protocol versions are
detected.

**Config Options:**

This test shares the configuration provided for the standard
* <a href='checks.html#checks/?languages=PYTHON&tools=BANDIT&rule=bandit.B502'>ssl_with_bad_version</a>
documentation.

## Example

``` python

>> Issue: Function definition identified with insecure SSL/TLS protocol
version by default, possible security issue.
Severity: Medium   Confidence: Medium
CWE: CWE-327 (https://cwe.mitre.org/data/definitions/327.html)
Location: ./examples/ssl-insecure-version.py:28
27
28  def open_ssl_socket(version=SSL.SSLv2_METHOD):
29      pass

```
## see also:

- :func:`ssl_with_bad_version`
- :func:`ssl_with_no_version`
- https://heartbleed.com/
- https://en.wikipedia.org/wiki/POODLE
- https://security.openstack.org/guidelines/dg_move-data-securely.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added

Changed in version  1.7.5
Added TLS 1.1


