Ensures that lifecycle methods are declared in order of execution

- Type: problem

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngOnInit(): void {}
  ngOnChanges(): void {}
  ~~~~~~~~~~~
  ngDoCheck(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngAfterViewInit(): void {}
  ngAfterViewChecked(): void {}
  ngOnDestroy(): void {}
  doSomething(): void {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngOnChanges(): void {}
  ngOnInit(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngOnDestroy(): void {}
  ngAfterViewChecked(): void {}
  ~~~~~~~~~~~~~~~~~~
  doSomething(): void {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngDoCheck(): void {}
  ngAfterContentInit(): void {}
  ngOnDestroy(): void {}
  ngAfterContentChecked(): void {}
  ~~~~~~~~~~~~~~~~~~~~~
  ngAfterViewChecked(): void {}
  doSomething(): void {}
  doSomethingElse(): void {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngOnInit(): void {}
  ngOnChanges(): void {}
  ~~~~~~~~~~~
 }
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnChanges(): void {}
  ngOnInit(): void {}
  ngDoCheck(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngAfterViewInit(): void {}
  ngAfterViewChecked(): void {}
  ngOnDestroy(): void {}
  doSomething(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnChanges(): void {}
  ngOnInit(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngAfterViewChecked(): void {}
  ngOnDestroy(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnChanges(): void {}
  ngOnInit(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngAfterViewChecked(): void {}
  ngOnDestroy(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngDoCheck(): void {}
  ngAfterContentInit(): void {}
  ngAfterContentChecked(): void {}
  ngAfterViewChecked(): void {}
  doSomething(): void {}
  doSomethingElse(): void {}
  doSomethingElseAgain(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnInit(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {}
```

</details>
