Ensures that the built-in control flow is used.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div *ngIf="condition"></div>
      ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngIf="condition; else elseBlock"></div>
      ~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngIf="condition; then thenBlock else elseBlock"></div>
      ~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div *ngIf="condition as value; else elseBlock"></div>
      ~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [ngIf]="condition"></div>
     ~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<li *ngFor="let item of items">
                     ~~~~~~~~
  {{ item }}
</li>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<li *ngFor="let item of items; index as i; trackBy: trackByFn">
                     ~~~~~~~~~~
  {{ item }}
</li>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template ngFor let-item [ngForOf]="items" let-i="index" [ngForTrackBy]="trackByFn">
                            ~~~~~~~~~~~~~~~~~
  <li>{{ item }}</li>
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<ng-template ngFor let-item [ngForOf]="items" let-i="index" [ngForTrackBy]="trackByFn">
                            ~~~~~~~~~~~~~~~~~
  <li>{{ item }}</li>
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<container-element [ngSwitch]="switch_expression">
                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   <some-element *ngSwitchCase="match_expression_1">1</some-element>
   <some-element *ngSwitchCase="match_expression_2">2</some-element>
   <some-element *ngSwitchDefault>default</some-element>
</container-element>
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
@if (condition) {
     Condition is truthy
  }
```

<br>

---

<br>

#### ✅ Valid Code

```html
@if (condition) {
    Condition is truthy
  } @else if (anotherCondition) {
    Another condition is truthy
  } @else {
    No condition is truthy
  }
```

<br>

---

<br>

#### ✅ Valid Code

```html
@for (item of items; track item.id) {
    {{ item.name }}
  } @empty {
    There are no items.
  }
```

<br>

---

<br>

#### ✅ Valid Code

```html
@switch (condition) {
    @case (caseA) {
      Case A.
    }
    @case (caseB) {
      Case B.
    }
    @default {
      Default case.
    }
  }
```

<br>

---

<br>

#### ✅ Valid Code

```html
<form [ngFormOptions]="{ updateOn: 'blur' }"></form>
```

</details>
