Enforce component methods order.


🔧 This rule is automatically fixable using the [`sort-comp` transform](https://github.com/reactjs/react-codemod/blob/master/transforms/sort-comp.js) in [react-codemod](https://www.npmjs.com/package/react-codemod).

When creating React components it is more convenient to always follow the same organisation for method order to help you easily find lifecycle methods, event handlers, etc.

## Rule Details

The default configuration ensures that the following order must be followed:

  1. static methods and properties
  2. lifecycle methods: `displayName`, `propTypes`, `contextTypes`, `childContextTypes`, `mixins`, `statics`, `defaultProps`, `constructor`, `getDefaultProps`, `state`, `getInitialState`, `getChildContext`, `getDerivedStateFromProps`, `componentWillMount`, `UNSAFE_componentWillMount`, `componentDidMount`, `componentWillReceiveProps`, `UNSAFE_componentWillReceiveProps`, `shouldComponentUpdate`, `componentWillUpdate`, `UNSAFE_componentWillUpdate`, `getSnapshotBeforeUpdate`, `componentDidUpdate`, `componentDidCatch`, `componentWillUnmount` (in this order).
  3. custom methods
  4. `render` method

Examples of **incorrect** code for this rule:

```jsx
var Hello = createReactClass({
  render: function() {
    return <div>Hello</div>;
  },
  displayName : 'Hello'
});
```

```jsx
class Hello extends React.Component {
  render() {
    return <div>Hello</div>;
  }
  static displayName = 'Hello';
}
```

Examples of **correct** code for this rule:

```jsx
var Hello = createReactClass({
  displayName : 'Hello',
  render: function() {
    return <div>Hello</div>;
  }
});
```

```jsx
class Hello extends React.Component {
  static displayName = 'Hello';
  render() {
    return <div>Hello</div>;
  }
}
```

## When Not To Use It

This rule is a formatting preference and not following it won't negatively affect the quality of your code. If components organisation isn't a part of your coding standards, then you can leave this rule off.
