### SCS0009 - Cookie Without HttpOnly Flag 

It is recommended to specify the HttpOnly flag to new cookie.

#### Risk

Cookies that doesn’t have the flag set are available to JavaScript running on the same domain. When a user is the target of a “Cross-Site Scripting”, the attacker would benefit greatly from getting the session id.

#### Vulnerable Code

The `httpOnlyCookies` value is explicitly set to `false` or the default is left.

```xml
<httpCookies httpOnlyCookies="false" [..] />

```

```cs
// default is left
var cookie = new HttpCookie("test");
// or explicitly set to false
var cookie = new HttpCookie("test");
cookie.HttpOnly = false;

```

#### Solution

```xml
<httpCookies httpOnlyCookies="true" [..] />

```

```cs
var cookie = new HttpCookie("test");
cookie.Secure = true;
cookie.HttpOnly = true; //Add this flag

```

#### References

[CWE-1004: Sensitive Cookie Without ‘HttpOnly’ Flag](https://cwe.mitre.org/data/definitions/1004.html)  
[Coding Horror blog: Protecting Your Cookies: HttpOnly](http://blog.codinghorror.com/protecting-your-cookies-httponly/)  
[OWASP: HttpOnly](https://www.owasp.org/index.php/HttpOnly)  
[Rapid7: Missing HttpOnly Flag From Cookie](https://www.rapid7.com/db/vulnerabilities/http-cookie-http-only-flag)

## View State

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)