### SCS0022 - Event Validation Disabled 

The `enableEventValidation` is disabled in configuration file.

#### Risk

This feature reduces the risk of unauthorized or malicious post-back requests and callbacks. It is strongly recommended that you do not disable event validation. When the EnableEventValidation property is set to true, ASP.NET validates that a control event originated from the user interface that was rendered by that control.

#### Vulnerable Code

```xml
<system.web>
   ...
   <pages [..] enableEventValidation="false" [..]/>
   ...
</system.web>

```

#### Solution

The default value is secure - `true`. Or set it explicitly:

```xml
<system.web>
   ...
   <pages [..] enableEventValidation="true" [..]/>
   ...
</system.web>

```

#### References

[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: pages Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/950xf363%28v=vs.100%29.aspx)  
[MSDN: Page.EnableEventValidation Property](http://msdn.microsoft.com/en-us/library/system.web.ui.page.enableeventvalidation.aspx)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)