### SCS0032 - Password RequiredLength Too Small 

The minimal length of a password is recommended to be set at least to 8.

#### Risk

Weak password can be guessed or brute-forced.

#### Vulnerable Code

```cs
PasswordValidator pwdv = new PasswordValidator
{
    RequiredLength = 6,
};

```

#### Solution

See the solution for [Password Complexity](#SCS0033)

#### References

[CWE-521: Weak Password Requirements](https://cwe.mitre.org/data/definitions/521.html)  
[MSDN: ASP.NET Identity PasswordValidator Class](https://msdn.microsoft.com/en-us/library/microsoft.aspnet.identity.passwordvalidator.aspx)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)