<h2>Why is this an issue?</h2>
<p>Casting expressions are utilized to convert one data type to another, such as transforming an integer into a string. This is especially crucial in
strongly typed languages like C, C++, C#, Java, Python, and others.</p>
<p>However, there are instances where casting expressions are not needed. These include situations like:</p>
<ul>
  <li> casting a variable to its own type </li>
  <li> casting a subclass to a parent class (in the case of polymorphism) </li>
  <li> the programming language is capable of automatically converting the given type to another </li>
</ul>
<p>These scenarios are considered unnecessary casting expressions. They can complicate the code and make it more difficult to understand, without
offering any advantages.</p>
<p>As a result, it’s generally advised to avoid unnecessary casting expressions. Instead, rely on the language’s type system to ensure type safety and
code clarity.</p>
<h3>Exceptions</h3>
<p>Issues are not raised against the <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/types/casting-and-type-conversions">default literal</a>.</p>
<h2>How to fix it</h2>
<p>To fix your code remove the unnecessary casting expression.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public int Example(int i)
{
    return (int) (i + 42); // Noncompliant
}

public IEnumerable&lt;int&gt; ExampleCollection(IEnumerable&lt;int&gt; coll)
{
    return coll.Reverse().OfType&lt;int&gt;(); // Noncompliant
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public int Example(int i)
{
    return i + 42;
}

public IEnumerable&lt;int&gt; ExampleCollection(IEnumerable&lt;int&gt; coll)
{
    return coll.Reverse();
}
</pre>
<pre>
bool b = (bool)default; // Doesn't raise an issue
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft - <a href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/types/casting-and-type-conversions">Casting and type
  conversions</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Type_conversion">Type Conversion</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Strong_and_weak_typing">Strong and Weak Typing</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Polymorphism_(computer_science)"> Polymorphism (Computer Science)</a> </li>
</ul>

