<h2>Why is this an issue?</h2>
<p>When the modulus of a negative number is calculated, the result will either be negative or zero. Thus, comparing the modulus of a variable for
equality with a positive number (or a negative one) could result in unexpected results.</p>
<h3>Noncompliant code example</h3>
<pre>
public bool IsOdd(int x)
{
  return x % 2 == 1;  // Noncompliant; if x is an odd negative, x % 2 == -1
}
</pre>
<h3>Compliant solution</h3>
<pre>
public bool IsOdd(int x)
{
  return x % 2 != 0;
}
</pre>
<p>or</p>
<pre>
public bool IsOdd(uint x)
{
  return x % 2 == 1;
}
</pre>

