<h2>Why is this an issue?</h2>
<p>A method is identified as a test method if it is marked with one of the following attributes:</p>
<ul>
  <li> <code>[TestMethod]</code> or <code>[DataTestMethod]</code> (for <strong>MSTest</strong>). </li>
  <li> <code>[Fact]</code> or <code>[Theory]</code> (for <strong>xUnit</strong>). </li>
  <li> <code>[Test]</code>, <code>[TestCase]</code>, <code>[TestCaseSource]</code>, or <code>[Theory]</code> (for <strong>NUnit</strong>). </li>
</ul>
<p>However, non-<code>public</code> methods are not considered test methods and will not be executed, regardless of whether they have a test
attribute. Additionally, methods with the <code>async void</code> modifier or methods that contain generics <code>&lt;T&gt;</code> anywhere in their
signatures are also excluded from being recognized as tests and will not be executed.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
[TestMethod]
void TestNullArg()  // Noncompliant, method is not public
{  /* ... */  }

[TestMethod]
public async void MyIgnoredTestMethod()  // Noncompliant, this is an 'async void' method
{ /* ... */ }

[TestMethod]
public void MyIgnoredGenericTestMethod&lt;T&gt;(T foo)  // Noncompliant, method has generics in its signature
{ /* ... */ }
</pre>
<pre data-diff-id="1" data-diff-type="compliant">
[TestMethod]
public void TestNullArg()
{  /* ... */  }

[TestMethod]
public async Task MyIgnoredTestMethod()
{ /* ... */ }

[TestMethod]
public void MyIgnoredGenericTestMethod(int foo)
{ /* ... */ }
</pre>
<h3>Exceptions</h3>
<p>For <strong>xUnit</strong>, accessibility is disregarded when it comes to <code>[Fact]</code> test methods, as they do not necessarily need to be
declared as <code>public</code>.</p>
<p>In <strong>xUnit</strong>, <code>[Theory]</code> test methods, as well as <code>[TestCase]</code> and <code>[TestCaseSource]</code> test methods in
<strong>NUnit</strong>, have the flexibility to be generic, allowing for a wider range of test scenarios.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-mstest">Unit testing C# with MSTest</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-nunit">Unit testing C# with NUnit</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/core/testing/unit-testing-with-dotnet-test">Unit testing C# with xUnit</a> </li>
</ul>

