<h2>Why is this an issue?</h2>
<p>According to the Task-based Asynchronous Pattern (TAP), methods returning either a <code>System.Threading.Tasks.Task</code> or a
<code>System.Threading.Tasks.Task&lt;TResult&gt;</code> are considered "asynchronous". Such methods should use the <code>Async</code> suffix.
Conversely methods which do not return such Tasks should not have an "Async" suffix in their names.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;
using  System.Threading.Tasks;

namespace myLibrary
{

  public class Foo
  {
    public Task Read(byte [] buffer, int offset, int count, // Noncompliant
                                CancellationToken cancellationToken)
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;
using  System.Threading.Tasks;

namespace myLibrary
{

  public class Foo
  {
    public Task ReadAsync(byte [] buffer, int offset, int count, CancellationToken cancellationToken)
  }
}
</pre>
<h3>Exceptions</h3>
<p>This rule doesn’t raise an issue when the method is an override or part of the implementation of an interface since it can not be renamed.</p>
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.microsoft.com/en-us/dotnet/standard/asynchronous-programming-patterns/task-based-asynchronous-pattern-tap">Task-based
  Asynchronous Pattern</a> </li>
</ul>

