<p><strong>This rule is deprecated, and will eventually be removed.</strong></p>
<p>Component parameters can only receive query parameter values in routable components with an @page directive.</p>
<h2>Why is this an issue?</h2>
<p><a
href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute">SupplyParameterFromQuery</a>
attribute is used to specify that a component parameter of a routable component comes from the <a
href="https://en.wikipedia.org/wiki/Query_string">query string</a>.</p>
<p>In the case of non-routable components, the <code>SupplyParameterFromQuery</code> does not contribute to the functionality, and removing it will
not affect the behavior.</p>
<h2>How to fix it</h2>
<p>Either make the component routable or remove the <code>SupplyParameterFromQuery</code> attribute.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
&lt;h3&gt;Component&lt;/h3&gt;

@code {
    [Parameter]
    [SupplyParameterFromQuery]  // Noncompliant
    public bool Param { get; set; }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
@page "/component"

&lt;h3&gt;Component&lt;/h3&gt;

@code {
    [Parameter]
    [SupplyParameterFromQuery]  // Compliant
    public bool Param { get; set; }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing#query-strings">Query strings</a> </li>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.components.supplyparameterfromqueryattribute">SupplyParameterFromQueryAttribute Class</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Query_string">query string</a> </li>
</ul>

