﻿## SA1003

<table>
<tr>
  <td>TypeName</td>
  <td>SA1003SymbolsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1003</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The spacing around an operator symbol is incorrect, within a C# code file.

## Rule description

A violation of this rule occurs when the spacing around an operator symbol is incorrect.

The following types of operator symbols should be surrounded by a single space on either side: colons, arithmetic
operators, assignment operators, conditional operators, logical operators, relational operators, shift operators, and
lambda operators. For example:

```csharp
int x = 4 + y;
```

In contrast, unary operators should be preceded by a single space, but should never be followed by any space. For example:

```csharp
bool x = !value;
```

An exception occurs whenever the symbol is preceded or followed by a parenthesis or bracket, in which case there should
be no space between the symbol and the bracket. For example:

```csharp
if (!value)
{
}
```

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the symbol follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1003:SymbolsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1003 // SymbolsMustBeSpacedCorrectly
#pragma warning restore SA1003 // SymbolsMustBeSpacedCorrectly
```
