﻿## SA1024

<table>
<tr>
  <td>TypeName</td>
  <td>SA1024ColonsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1024</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A colon within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a colon is not correct.

The spacing around a colon depends upon the type of colon and how it is used within the code. A colon appearing within an element declaration should always have a single space on either side, unless it is the first or last character on the line. For example all of the colons below follow this rule:

```csharp
public class Class2<T> : Class1 where T : MyType
{
    public Class2(int x) : base(x)
    {
    }
}
```

When the colon comes at the end of a label or case statement, it should always be followed by whitespace or be the last character on the line, but should never be preceded by whitespace. For example:

```csharp
_label:
switch (x)
{
    case 2: 
        return x;
}
```

A colon that appears as part of a string interpolation formatting component should not have leading whitespace characters. For example:

```csharp
var s = $"{x:N}";
```

Finally, when a colon is used within a conditional statement, it should always contain a single space on either side, unless the colon is the first or last character on the line. For example:

```csharp
int x = y ? 2 : 3;
```

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the colon follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1024:ColonsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1024 // ColonsMustBeSpacedCorrectly
#pragma warning restore SA1024 // ColonsMustBeSpacedCorrectly
```
