# SA1104

<table>
<tr>
  <td>Title</td>
  <td>Query clause should begin on new line when previous clause spans multiple lines</td>
</tr>
<tr>
  <td>TypeName</td>
  <td>SA110xQueryClauses</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1104</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A clause within a C# query expression begins on the same line as the previous clause, when the previous clause spans across multiple lines.

## Rule description

A violation of this rule occurs when a query clause spans across multiple lines, and the next clause begins on the same line as the end of the previous clause. For example:
```c#
    var elementNames =
        from element in GetElements
        (
            12,
			45
        ) select element.Name;
```

The query clauses can correctly be written as:
```c#
    var elementNames =
        from element in GetElements
        (
            12,
			45
        )
		select element.Name;
```
 
## How to fix violations

To fix a violation of this rule, move the clause down to start on the next line.

## How to suppress violations

```c#
#pragma warning disable SA1104 // Query clause should begin on new line when previous clause spans multiple lines
    var elementNames =
        from element in GetElements
        (
            12,
			45
        ) select element.Name;
#pragma warning restore SA1104 // Query clause should begin on new line when previous clause spans multiple lines
```
