## SA1141

<table>
<tr>
  <td>TypeName</td>
  <td>SA1141UseTupleSyntax</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1141</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.
:memo: This rule is only active for C# 7.0 and higher

## Cause

A ValueTuple type declaration was used instead of the preferred tuple language construct. 

## Rule description

A ValueTuple type declaration was used instead of the preferred tuple language construct.  See the documentation on [tuple types](https://docs.microsoft.com/en-us/dotnet/csharp/tuples) for information on how to work with tuples in C# 7.

For example, the following code would produce a violation of this rule:

```csharp
ValueTuple<int, int> x; // SA1141
```

The following code would not produce any violations:

```csharp
(int, int) x;
```

## How to fix violations

To fix a violation of this rule, use the appropriate tuple type in code instead of the ValueTuple type.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1141:UseTupleSyntax", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1141 // Use tuple syntax
#pragma warning restore SA1141 // Use tuple syntax
```
