﻿## SA1300

<table>
<tr>
  <td>TypeName</td>
  <td>SA1300ElementMustBeginWithUpperCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1300</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

The name of a C# element does not begin with an upper-case letter.

## Rule description

A violation of this rule occurs when the names of certain types of elements do not begin with an upper-case letter. The
following types of elements should use an upper-case letter as the first letter of the element name:

* Namespaces
* Classes
* Enums
* Enum members
* Structs
* Delegates
* Events
* Methods
* Properties

In addition, any field which is public, internal, or marked with the const attribute should begin with an upper-case
letter. Non-private readonly fields should also be named using an upper-case letter.

If the field or variable name is intended to match the name of an item associated with Win32 or COM, and thus needs to
begin with a lower-case letter, place the field or variable within a special `NativeMethods` class. A `NativeMethods`
class is any class which contains a name ending in `NativeMethods`, and is intended as a placeholder for Win32 or COM
wrappers. StyleCop will ignore this violation if the item is placed within a `NativeMethods` class.

For namespace components that begin with a small letter, due to branding issues or other reasons, add the appropriate
term to the `allowedNamespaceComponents` list.

## How to fix violations

To fix a violation of this rule, change the name of the element so that it begins with an upper-case letter, place
the item within a `NativeMethods` class if appropriate, or add it to the `allowedNamespaceComponents` list if
it is a namespace component.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1300:ElementMustBeginWithUpperCaseLetter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1300 // ElementMustBeginWithUpperCaseLetter
#pragma warning restore SA1300 // ElementMustBeginWithUpperCaseLetter
```
