﻿## SA1507

<table>
<tr>
  <td>TypeName</td>
  <td>SA1507CodeMustNotContainMultipleBlankLinesInARow</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1507</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

The C# code contains multiple blank lines in a row.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when the code contains more than one blank line in a row. For example:

```csharp
public bool Enabled
{
    get 
    { 
        Console.WriteLine("Getting the enabled flag.");


        return this.enabled; 
    }
}
```

The code above would generate an instance of this violation, since it contains blank multiple lines in a row.

## How to fix violations

To fix a violation of this rule, remove the extra blank lines.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1507:CodeMustNotContainMultipleBlankLinesInARow", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1507 // CodeMustNotContainMultipleBlankLinesInARow
#pragma warning restore SA1507 // CodeMustNotContainMultipleBlankLinesInARow
```
