﻿## SA1510

<table>
<tr>
  <td>TypeName</td>
  <td>SA1510ChainedStatementBlocksMustNotBePrecededByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1510</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

Chained C# statements are separated by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

Some types of C# statements can only be used when chained to the bottom of another statement. Examples include catch and finally statements, which must always be chained to the bottom of a try-statement. Another example is an else-statement, which must always be chained to the bottom of an if-statement, or to another else-statement. These types of chained statements should not be separated by a blank line. For example:

```csharp
try
{
    this.SomeMethod();
}

catch (Exception ex)
{
    Console.WriteLine(ex.ToString());
}
```

## How to fix violations

To fix a violation of this rule, remove any blank lines between the chained statements.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1510:ChainedStatementBlocksMustNotBePrecededByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1510 // ChainedStatementBlocksMustNotBePrecededByBlankLine
#pragma warning restore SA1510 // ChainedStatementBlocksMustNotBePrecededByBlankLine
```
